```toml
[advisory]
id = "RUSTSEC-2024-0405"
package = "rustyscript"
date = "2024-07-18"
url = "https://github.com/rscarson/rustyscript/issues/174"
categories = ["denial-of-service"]

[versions]
patched = [">= 0.6.1"]
unaffected = ["<= 0.3.0"]
```

# op_panic in the base runtime can force a panic in the runtime's containing thread

Affected versions use deno_core releases that expose `Deno.core.ops.op_panic` to the JS runtime in the base core

This function when called triggers a manual panic in the thread containing the runtime.

It can be fixed by stubbing out the exposed op:
```javascript
Deno.core.ops.op_panic = (msg) => { throw new Error(msg) };
```
