```toml
[advisory]
id = "RUSTSEC-2016-0005"
package = "rust-crypto"
date = "2016-09-06"
informational = "unmaintained"
url = "https://github.com/DaGenix/rust-crypto/issues/440"

[versions]
patched = []
unaffected = ["> 0.2.36"]
```

# rust-crypto is unmaintained; switch to a modern alternative

The `rust-crypto` crate has not seen a release or GitHub commit since 2016,
and its author is unresponsive.

*NOTE: The (old) `rust-crypto` crate (with hyphen) should not be confused with
similarly named (new) [RustCrypto GitHub Org] (without hyphen). The GitHub Org
is actively maintained.*

We recommend you switch to one of the following crates instead, depending on
which algorithms you need:

- [dalek-cryptography GitHub Org]:
  - Key agreement: [`x25519-dalek`]
  - Signature algorithms: [`ed25519-dalek`]
- [`ring`]:
  - AEAD algorithms: AES-GCM, ChaCha20Poly1305
  - Digest algorithms: SHA-256, SHA-384, SHA-512, SHA-512/256 (legacy: SHA-1)
  - HMAC
  - Key agreement: ECDH (P-256, P-384), X25519
  - Key derivation: HKDF
  - Password hashing: PBKDF2
  - Signature algorithms: ECDSA (P-256, P-384), Ed25519, RSA (PKCS#1v1.5, PSS)
- [RustCrypto GitHub Org]:
  - AEAD algorithms: [`aes-gcm`], [`aes-gcm-siv`], [`aes-siv`], [`chacha20poly1305`], [`xsalsa20poly1305`]
  - Block ciphers: [`aes`], [`cast5`], [`des`]
  - Digest algorithms: [`sha2`], [`sha3`], [`blake2`], [`ripemd160`]
    (legacy: [`sha-1`], [`md-5`])
  - Key derivation: [`hkdf`]
  - MACs: [`cmac`], [`hmac`], [`pmac`], [`poly1305`]
  - Password hashing: [`pbkdf2`]
  - Stream ciphers: [`aes-ctr`], [`chacha20`], [`hc-256`], [`salsa20`]
- [`secp256k1`]:
  - Key agreement: ECDH (secp256k1 only)
  - Signature algorithms: ECDSA (secp256k1 only)
- [`orion`]:
  - AEAD algorithms: ChaCha20Poly1305 (IETF version), XChaCha20Poly1305
  - Digest algorithms: SHA-512, BLAKE2b
  - Key derivation: HKDF
  - MACs: HMAC, Poly1305
  - Password hashing: PBKDF2
  - Stream ciphers: ChaCha20 (IETF version), XChaCha20

[dalek-cryptography GitHub Org]: https://github.com/dalek-cryptography
[RustCrypto GitHub Org]: https://github.com/RustCrypto
[`aes`]: https://crates.io/crates/aes
[`aes-ctr`]: https://crates.io/crates/aes-ctr
[`aes-gcm`]: https://crates.io/crates/aes-gcm
[`aes-gcm-siv`]: https://crates.io/crates/aes-gcm-siv
[`aes-siv`]: https://crates.io/crates/aes-siv
[`blake2`]: https://crates.io/crates/blake2
[`cast5`]: https://crates.io/crates/cast5
[`chacha20`]: https://crates.io/crates/chacha20
[`chacha20poly1305`]: https://crates.io/crates/chacha20poly1305
[`cmac`]: https://crates.io/crates/cmac
[`des`]: https://crates.io/crates/des
[`ed25519-dalek`]: https://crates.io/crates/ed25519-dalek
[`hc-256`]: https://crates.io/crates/hc-256
[`hkdf`]: https://crates.io/crates/hkdf
[`hmac`]: https://crates.io/crates/hmac
[`pbkdf2`]: https://crates.io/crates/pbkdf2
[`pmac`]: https://crates.io/crates/pmac
[`poly1305`]: https://crates.io/crates/poly1305
[`ring`]: https://crates.io/crates/ring
[`ripemd160`]: https://crates.io/crates/ripemd160
[`salsa20`]: https://crates.io/crates/salsa20
[`secp256k1`]: https://crates.io/crates/secp256k1
[`sha-1`]: https://crates.io/crates/sha-1
[`sha2`]: https://crates.io/crates/sha2
[`sha3`]: https://crates.io/crates/sha3
[`x25519-dalek`]: https://crates.io/crates/x25519-dalek
[`xsalsa20poly1305`]: https://crates.io/crates/xsalsa20poly1305
[`orion`]: https://crates.io/crates/orion
