```toml
[advisory]
id = "RUSTSEC-2020-0098"
package = "rusb"
aliases = ["CVE-2020-36206", "GHSA-9mxw-4856-9cm5"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H"
date = "2020-12-18"
url = "https://github.com/a1ien/rusb/issues/44"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]
informational = "unsound"

[versions]
patched = [">= 0.7.0"]
unaffected = []
```

# UsbContext trait did not require implementers to be Send and Sync.

Affected versions of `rusb` did not require `UsbContext` to implement `Send`
and `Sync`. However, through `Device` and `DeviceHandle` it is possible to use
`UsbContext`s across threads.

This issue allows non-thread safe `UsbContext` types to be used concurrently
leading to data races and memory corruption.

The issue was fixed by adding `Send` and `Sync` bounds to `UsbContext`.
