```toml
[advisory]
id = "RUSTSEC-2020-0029"
package = "rgb"
aliases = ["CVE-2020-25016", "GHSA-g4rw-8m5q-6453"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N"
date = "2020-06-14"
informational = "unsound"
keywords = ["type confusion"]
url = "https://github.com/kornelski/rust-rgb/issues/35"

[versions]
patched = [">= 0.8.20"]
unaffected = ["< 0.5.4"]
```

# Allows viewing and modifying arbitrary structs as bytes

Affected versions of rgb crate allow viewing and modifying data of any type `T` wrapped in `RGB<T>` as bytes,
and do not correctly constrain `RGB<T>` and other wrapper structures to the types for which it is safe to do so.

Safety violation possible for a type wrapped in `RGB<T>` and similar wrapper structures:

 * If `T` contains padding, viewing it as bytes may lead to exposure of contents of uninitialized memory.
 * If `T` contains a pointer, modifying it as bytes may lead to dereferencing of arbitrary pointers.
 * Any safety and/or validity invariants for `T` may be violated.
 
The issue was resolved by requiring all types wrapped in structures provided by RGB crate to implement an unsafe marker trait.
