```toml
[advisory]
id = "RUSTSEC-2021-0018"
package = "qwutils"
aliases = ["CVE-2021-26954", "GHSA-68p4-pjpf-xwcq"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L"
date = "2021-02-03"
url = "https://github.com/qwertz19281/rust_utils/issues/3"
categories = ["memory-corruption"]
keywords = ["memory-safety", "double-free"]

[versions]
patched = [">= 0.3.1"]

[affected]
functions = { "qwutils::imp::vec::VecExt::insert_slice_clone" = ["< 0.3.1"] }
```

# insert_slice_clone can double drop if Clone panics.

Affected versions of this crate used `ptr::copy` when inserting into the middle
of a `Vec`. When ownership was temporarily duplicated during this copy, it calls
the clone method of a user provided element.

This issue can result in an element being double-freed if the clone call panics.

Commit `20cb73d` fixed this issue by adding a `set_len(0)` call before
operating on the vector to avoid dropping the elements during a panic.
