```toml
[advisory]
id = "RUSTSEC-2022-0052"
package = "os_socketaddr"
date = "2022-08-26"
url = "https://github.com/a-ba/os_socketaddr/issues/3"
categories = ["memory-corruption"]
keywords = ["memory", "layout", "cast"]
informational = "unsound"
aliases = ["GHSA-c439-chv8-8g2j"]

[versions]
patched = [">= 0.2.2"]
```

# `os_socketaddr` invalidly assumes the memory layout of std::net::SocketAddr

The [`os_socketaddr`](https://crates.io/crates/os_socketaddr) crate has assumed
`std::net::SocketAddrV4` and `std::net::SocketAddrV6` have the same memory layout as the system C
representation `sockaddr`. It has simply casted the pointers to convert the socket addresses to the
system representation.

These layout were [changed into idiomatic rust types](https://github.com/rust-lang/rust/pull/78802)
in nightly `std`. Starting from rustc 1.64 the affected versions of this crate will have undefined
behaviour.

