```toml
[advisory]
id = "RUSTSEC-2022-0047"
package = "oqs"
date = "2022-02-25"
url = "https://groups.google.com/a/list.nist.gov/g/pqc-forum/c/KFgw5_qCXiI?pli=1"
categories = ["crypto-failure"]
aliases = ["GHSA-h864-m8vm-3xvj"]

# affected enum variants ([affected.functions] requires functions)
#"oqs::sig::Algorithm::RainbowIaClassic" = ["< 0.5.0, >= 0.2.0"]
#"oqs::sig::Algorithm::RainbowIaCyclic" = ["< 0.5.0, >= 0.2.0"]
#"oqs::sig::Algorithm::RainbowIaCyclicCompressed" = ["< 0.5.0, >= 0.2.0"]
#"oqs::sig::Algorithm::RainbowIClassic" = ["< 0.7.2, >= 0.5.0"]
#"oqs::sig::Algorithm::RainbowICircumzenithal" = ["< 0.7.2, >= 0.5.0"]
#"oqs::sig::Algorithm::RainbowICompressed" = ["< 0.7.2, >= 0.5.0"]


# Versions which include fixes for this vulnerability (mandatory)
[versions]
patched = [">= 0.7.2"]
```

# Post-Quantum Signature scheme Rainbow level I parametersets broken

Ward Beullens found a practical key-recovery attack against Rainbow.
The level I parametersets are removed from liboqs starting from version `0.7.2`.
Find the scientific details in [Breaking Rainbow Takes a Weekend on a Laptop](https://eprint.iacr.org/2022/214).

This means all the `oqs::sig::Algorithm::RainbowI*` variants are insecure.
