```toml
[advisory]
id = "RUSTSEC-2023-0023"
package = "openssl"
date = "2023-03-24"
url = "https://github.com/sfackler/rust-openssl/pull/1854"
categories = ["file-disclosure"]
aliases = ["GHSA-9qwg-crg9-m2vc"]

[affected]
functions = { "openssl::x509::extension::SubjectAlternativeName::new" = ["< 0.10.48, >=0.9.7"], "openssl::x509::extension::ExtendedKeyUsage::other" = ["< 0.10.48, >=0.9.7"] }

[versions]
patched = [">= 0.10.48"]
```

# `openssl` `SubjectAlternativeName` and `ExtendedKeyUsage::other` allow arbitrary file read

`SubjectAlternativeName` and `ExtendedKeyUsage` arguments were parsed using the OpenSSL
function `X509V3_EXT_nconf`. This function parses all input using an OpenSSL mini-language
which can perform arbitrary file reads.

Thanks to David Benjamin (Google) for reporting this issue.
