```toml
[advisory]
id = "RUSTSEC-2023-0013"
package = "openssl-src"
aliases = ["CVE-2023-0401", "GHSA-vrh7-x64v-7vxq"]
categories = ["denial-of-service"]
date = "2023-02-07"
url = "https://www.openssl.org/news/secadv/20230207.txt"
[versions]
patched = [">= 300.0.12"]
unaffected = ["< 300.0.0"]
```

# `NULL` dereference during PKCS7 data verification

A `NULL` pointer can be dereferenced when signatures are being
verified on PKCS7 `signed` or `signedAndEnveloped` data. In case the hash
algorithm used for the signature is known to the OpenSSL library but
the implementation of the hash algorithm is not available the digest
initialization will fail. There is a missing check for the return
value from the initialization function which later leads to invalid
usage of the digest API most likely leading to a crash.

The unavailability of an algorithm can be caused by using FIPS
enabled configuration of providers or more commonly by not loading
the legacy provider.

PKCS7 data is processed by the SMIME library calls and also by the
time stamp (TS) library calls. The TLS implementation in OpenSSL does
not call these functions however third party applications would be
affected if they call these functions to verify signatures on untrusted
data.
