```toml
[advisory]
id = "RUSTSEC-2023-0011"
package = "openssl-src"
aliases = ["CVE-2023-0216", "GHSA-29xx-hcv2-c4cp"]
categories = ["denial-of-service"]
date = "2023-02-07"
url = "https://www.openssl.org/news/secadv/20230207.txt"
[versions]
patched = [">= 300.0.12"]
unaffected = ["< 300.0.0"]
```

# Invalid pointer dereference in `d2i_PKCS7` functions

An invalid pointer dereference on read can be triggered when an
application tries to load malformed PKCS7 data with the
`d2i_PKCS7()`, `d2i_PKCS7_bio()` or `d2i_PKCS7_fp()` functions.

The result of the dereference is an application crash which could
lead to a denial of service attack. The TLS implementation in OpenSSL
does not call this function however third party applications might
call these functions on untrusted data.
