```toml
[advisory]
id = "RUSTSEC-2022-0025"
package = "openssl-src"
aliases = ["CVE-2022-1473", "GHSA-g323-fr93-4j3c"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2022-05-03"
url = "https://www.openssl.org/news/secadv/20220503.txt"

[versions]
patched = [">= 300.0.6"]
unaffected = ["< 300.0"]
```

# Resource leakage when decoding certificates and keys

The `OPENSSL_LH_flush()` function, which empties a hash table, contains
a bug that breaks reuse of the memory occupied by the removed hash
table entries.

This function is used when decoding certificates or keys. If a long lived
process periodically decodes certificates or keys its memory usage will
expand without bounds and the process might be terminated by the operating
system causing a denial of service. Also traversing the empty hash table
entries will take increasingly more time.

Typically such long lived processes might be TLS clients or TLS servers
configured to accept client certificate authentication.
