```toml
[advisory]
id = "RUSTSEC-2021-0056"
package = "openssl-src"
aliases = ["CVE-2021-3450", "GHSA-8hfj-xrj2-pm22"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N"
categories = ["crypto-failure"]
date = "2021-05-01"
url = "https://www.openssl.org/news/secadv/20210325.txt"

[versions]
patched = [">= 111.15"]
unaffected = ["< 111.11"]
```

# CA certificate check bypass with X509_V_FLAG_X509_STRICT

The X509_V_FLAG_X509_STRICT flag enables additional security checks of the
certificates present in a certificate chain. It is not set by default.

Starting from OpenSSL version 1.1.1h a check to disallow certificates in
the chain that have explicitly encoded elliptic curve parameters was added
as an additional strict check.

An error in the implementation of this check meant that the result of a
previous check to confirm that certificates in the chain are valid CA
certificates was overwritten. This effectively bypasses the check
that non-CA certificates must not be able to issue other certificates.

If a "purpose" has been configured then there is a subsequent opportunity
for checks that the certificate is a valid CA.  All of the named "purpose"
values implemented in libcrypto perform this check.  Therefore, where
a purpose is set the certificate chain will still be rejected even when the
strict flag has been used. A purpose is set by default in libssl client and
server certificate verification routines, but it can be overridden or
removed by an application.

In order to be affected, an application must explicitly set the
X509_V_FLAG_X509_STRICT verification flag and either not set a purpose
for the certificate verification or, in the case of TLS client or server
applications, override the default purpose.
