```toml
[advisory]
id = "RUSTSEC-2021-0138"
package = "mz-avro"
date = "2021-10-14"
url = "https://github.com/MaterializeInc/materialize/issues/8669"
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["GHSA-jwh2-vrr9-vcp2"]

[versions]
patched = [">= 0.7.0"]
```

# Incorrect use of `set_len` allows for un-initialized memory

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` 
implementation.

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure)
and also can return incorrect number of bytes written to the buffer.
Reading from uninitialized memory produces undefined values that can quickly invoke
undefined behavior.

Note: there is only UB in the case where a user provides a struct whose `Read`
implementation inspects the buffer passed to `read_exact` before writing to it.
This is an unidiomatic (albeit possible) `Read` implementation.

See https://github.com/MaterializeInc/materialize/issues/8669 for details.
