```toml
[advisory]
id = "RUSTSEC-2020-0165"
package = "mozjpeg"
date = "2020-07-04"
keywords = ["type confusion"]
url = "https://github.com/ImageOptim/mozjpeg-rust/issues/10"
categories = ["memory-corruption"]
references = ["https://github.com/kornelski/rust-rgb/issues/35", "https://rustsec.org/advisories/RUSTSEC-2020-0029.html"]
informational = "unsound"
aliases = ["GHSA-v8gq-5grq-9728"]

[affected]
functions = { "mozjpeg::DecompressScanlines::read_scanlines" = ["< 0.8.19"] }

[versions]
patched = [">= 0.8.19"]
```

# mozjpeg DecompressScanlines::read_scanlines is Unsound

This issue and vector is similar to [RUSTSEC-2020-0029] of `rgb` crate which `mozjpeg` depends on.

Affected versions of `mozjpeg` crate allow creating instances of any type `T` from bytes,
and do not correctly constrain `T` to the types for which it is safe to do so.

Examples of safety violation possible for a type `T`:

* `T` contains a reference type, and it constructs a pointer to an invalid, arbitrary memory address.
* `T` requires a safety and/or validity invariant for its construction that may be violated.

The issue was fixed in 0.8.19 by using safer types and involving `rgb` dependency bump.

[RUSTSEC-2020-0029]: https://rustsec.org/advisories/RUSTSEC-2020-0029.html
