```toml
[advisory]
id = "RUSTSEC-2022-0009"
package = "libp2p-core"
date = "2022-02-07"
categories = ["crypto-failure"]
aliases = ["GHSA-wc36-xgcc-jwpr"]

[affected]
functions = { "libp2p_core::PeerRecord::from_signed_envelope" = [">= 0.30.0-rc.1"] }

[versions]
unaffected = ["< 0.30.0-rc.1"]
patched = ["^ 0.30.2", ">= 0.31.1"]
```

# Failure to verify the public key of a `SignedEnvelope` against the `PeerId` in a `PeerRecord`

Affected versions of this crate did not check that the public key the signature was created with matches the peer ID of the peer record. 
Any combination was considered valid.

This allows an attacker to republish an existing `PeerRecord` with a different `PeerId`.
