```toml
[advisory]
id = "RUSTSEC-2020-0017"
package = "internment"
aliases = ["CVE-2020-35874", "GHSA-96w3-p368-4h8c"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2020-05-28"
url = "https://github.com/droundy/internment/issues/11"

[affected.functions]
"internment::ArcIntern::drop" = [">= 0.3.12"]

[versions]
patched = [">= 0.4.0"]
unaffected = ["< 0.3.12"]
```

# Use after free in ArcIntern::drop

`ArcIntern::drop` has a race condition where it can release memory
which is about to get another user. The new user will get a reference
to freed memory.

This was fixed by serializing access to an interned object while it
is being deallocated.

Versions prior to 0.3.12 used stronger locking which avoided the problem.
