```toml
[advisory]
id = "RUSTSEC-2021-0020"
package = "hyper"
date = "2021-02-05"
url = "https://github.com/hyperium/hyper/security/advisories/GHSA-6hfq-h8hq-87mf"
categories = ["format-injection"]
keywords = ["http", "request-smuggling"]
aliases = ["CVE-2021-21299", "GHSA-6hfq-h8hq-87mf"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.14.3", "0.13.10", "0.12.36"]
unaffected = ["< 0.12.0"]
```

# Multiple Transfer-Encoding headers misinterprets request payload

hyper's HTTP server code had a flaw that incorrectly understands some requests
with multiple transfer-encoding headers to have a chunked payload, when it
should have been rejected as illegal. This combined with an upstream HTTP proxy
that understands the request payload boundary differently can result in
"request smuggling" or "desync attacks".
