```toml
[advisory]
id = "RUSTSEC-2017-0002"
package = "hyper"
aliases = ["CVE-2017-18587", "GHSA-q89x-f52w-6hj2"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N"
date = "2017-01-23"
url = "https://github.com/hyperium/hyper/wiki/Security-001"

[versions]
patched = [">= 0.10.2", "< 0.10.0, >= 0.9.18"]
```

# headers containing newline characters can split messages

Serializing of headers to the socket did not filter the values for newline bytes (`\r` or `\n`),
which allowed for header values to split a request or response. People would not likely include
newlines in the headers in their own applications, so the way for most people to exploit this
is if an application constructs headers based on unsanitized user input.

This issue was fixed by replacing all newline characters with a space during serialization of
a header value.
