```toml
[advisory]
id = "RUSTSEC-2022-0069"
package = "hyper-staticfile"
date = "2022-11-30"
url = "https://github.com/stephank/hyper-staticfile/issues/35"
categories = ["file-disclosure"]
keywords = ["directory traversal", "http"]
aliases = ["GHSA-7p7c-pvvx-2vx3"]

[affected]
os = ["windows"]

[versions]
patched = ["^0.9.2", ">= 0.10.0-alpha.2"]
```

# Improper validation of Windows paths could lead to directory traversal attack

Path resolution in `hyper-staticfile` didn't correctly validate Windows paths
meaning paths like `/foo/bar/c:/windows/web/screen/img101.png` would be allowed
and respond with the contents of `c:/windows/web/screen/img101.png`. Thus users
could potentially read files anywhere on the filesystem.

This only impacts Windows. Linux and other unix likes are not impacted by this.
