```toml
[advisory]
id = "RUSTSEC-2019-0034"
package = "http"
aliases = ["CVE-2019-25009", "GHSA-6rhx-hqxm-8p36"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2019-11-16"
keywords = ["memory-safety", "double-free", "unsound"]

[affected.functions]
"http::header::HeaderMap::drain" = ["< 0.1.20"]

[versions]
patched = [">= 0.1.20"]
```

# HeaderMap::Drain API is unsound

Affected versions of this crate incorrectly used raw pointer,
which introduced unsoundness in its public safe API.

[Failing to drop the Drain struct causes double-free](https://github.com/hyperium/http/issues/354),
and [it is possible to violate Rust's alias rule and cause data race with Drain's Iterator implementation](https://github.com/hyperium/http/issues/355).

The flaw was corrected in 0.1.20 release of `http` crate.
