```toml
[advisory]
id = "RUSTSEC-2024-0402"
package = "hashbrown"
date = "2024-10-11"
url = "https://github.com/rust-lang/hashbrown/issues/576"
categories = []
keywords = ["borsh"]

[versions]
patched = [">= 0.15.1"]
unaffected = ["< 0.15.0"]

[affected]
functions = { "hashbrown::HashMap::borsh_serialize" = ["=0.15.0"] }
```

# Borsh serialization of HashMap is non-canonical

The borsh serialization of the HashMap did not follow the borsh specification.
It potentially produced non-canonical encodings dependent on insertion order.
It also did not perform canonicty checks on decoding.

This can result in consensus splits and cause equivalent objects to be
considered distinct.

This was patched in 0.15.1.
