```toml
[advisory]
id = "RUSTSEC-2024-0332"
package = "h2"
date = "2024-04-03"
references = ["https://seanmonstar.com/blog/hyper-http2-continuation-flood/"]
categories = ["denial-of-service"]
keywords = ["http", "http2", "h2"]
aliases = ["GHSA-q6cp-qfwq-4gcv"]

[versions]
patched = ["^0.3.26", ">= 0.4.4"]
```

# Degradation of service in h2 servers with CONTINUATION Flood

An attacker can send a flood of CONTINUATION frames, causing `h2` to process them indefinitely.
This results in an increase in CPU usage.

Tokio task budget helps prevent this from a complete denial-of-service, as the server can still
respond to legitimate requests, albeit with increased latency.

More details at "https://seanmonstar.com/blog/hyper-http2-continuation-flood/.

Patches available for 0.4.x and 0.3.x versions.
