```toml
[advisory]
id = "RUSTSEC-2024-0364"
package = "gitoxide-core"
date = "2024-08-22"
url = "https://github.com/Byron/gitoxide/security/advisories/GHSA-88g2-r9rw-g55h"
references = [
    "https://github.com/advisories/GHSA-88g2-r9rw-g55h",
    "https://nvd.nist.gov/vuln/detail/CVE-2024-43785",
    "https://github.com/Byron/gitoxide/issues/1534",

]
cvss = "CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:L/A:N"
keywords = ["terminal", "control-characters", "escape-sequences"]
aliases = ["CVE-2024-43785", "GHSA-88g2-r9rw-g55h"]
license = "CC0-1.0"

[versions]
patched = []
```

# gitoxide-core does not neutralize special characters for terminals

### Summary

The `gix` and `ein` commands write pathnames and other metadata literally to terminals, even if they contain characters terminals treat specially, including ANSI escape sequences. This sometimes allows an untrusted repository to misrepresent its contents and to alter or concoct error messages.

### Details

`gitoxide-core`, which provides most underlying functionality of the `gix` and `ein` commands, does not neutralize newlines, backspaces, or control characters—including those that form ANSI escape sequences—that appear in a repository's paths, author and committer names, commit messages, or other metadata. Such text may be written as part of the output of a command, as well as appearing in error messages when an operation fails.

ANSI escape sequences are of particular concern because, when printed to a terminal, they can change colors, including to render subsequent text unreadable; reposition the cursor to write text in a different location, including where text has already been written; clear the terminal; set the terminal title-bar text to arbitrary values; render the terminal temporarily unusable; and other such operations.

The effect is mostly an annoyance. But the author of a malicious repository who can predict how information from the repository may be accessed can cause files in the repository to be concealed or otherwise misrepresented, as well as rewrite all or part of error messages, or mimic error messages convincingly by repositioning the cursor and writing colored text.

### PoC

On a Unix-like system in a POSIX-compatible shell, run:

```sh
git init misleading-path
cd misleading-path
touch "$(printf '\033]0;Boo!\007\033[2K\r\033[91mError: Repository is corrupted. Run \033[96mEVIL_COMMAND\033[91m to attempt recovery.\033[0m')"
git add .
git commit -m 'Initial commit'
```

In the repository—or, if desired, in a clone of it, to show that this is exploitable by getting a user to clone an untrusted repository—run this command, which outputs entries in a three-column form showing type, hash, and filename:

```sh
gix tree entries
```

Although the output is of that form, it does not appear to be. Instead, the output in a terminal looks like this, colorized to appear to be an error message, with `EVIL_COMMAND` in another color, and with no other text:

```text
Error: Repository is corrupted. Run EVIL_COMMAND to attempt recovery.
```

In some terminals, a beep or other sound will be made. In most terminals, the title bar text will be changed to `Boo!`, though in some shells this may be immediately undone when printing the prompt. These elements are included to showcase the abilities of ANSI escape sequences, but they are not usually themselves threats.

To see what is actually produced, `gix tree entries` can be piped to a command that displays special characters symbolically, such as `less` or `cat -v` if available.

```text
BLOB e69de29bb2d1d6434b8b29ae775ad8c2e48c5391 ESC]0;Boo!^GESC[2K^MESC[91mError: Repository is corrupted. Run ESC[96mEVIL_COMMANDESC[91m to attempt recovery.ESC[0m
```

That shows the effect on `gix tree entries`, but various other commands are also affected, and the escape sequences and other special characters can also appear in non-path metadata, such as in the `user.name` used to create a commit.

### Impact

For users who do not clone or operate in clones of untrusted repositories, there is no impact.

Windows is much less affected than Unix-like systems due to limitations on what characters can appear in filenames, and because traditionally Windows terminals do not support as many ANSI escape sequences.

Because different `gix` and `ein` commands display different data in different formats, the author of a malicious repository must guess how it will be used, which complicates crafting truly convincing output, though it may be possible to craft a repository where `gix clone` fails to clone it but produces a misleading message.

Although this is mainly exploitable on systems *other* than Windows, in the ability to produce misleading output this superficially resembles [CVE-2024-35197](https://github.com/advisories/GHSA-49jc-r788-3fc9). But this is much more limited, because:

- The misleading output can only be made to go where the application is already sending output. Redirection is not defeated, and devices to access cannot be chosen by the attacker.
- The misleading output can only be take place *when* the application is already producing output. This limitation complicates the production of believable messages.
- Only terminals are affected. Even if a standard stream is redirected to another file or device, these special characters would not have a special effect, unless echoed later without sanitization.
- Reading and blocking cannot be performed.
- Applications other than the gitoxide `gix` and `ein` executables are unaffected. The exception is if another application uses `gitoxide-core`. But this is explicitly discouraged in the `gitoxide-core` documentation and is believed to be rare.
