```toml
[advisory]
id = "RUSTSEC-2019-0028"
package = "flatbuffers"
aliases = ["CVE-2019-25004", "GHSA-gx73-2498-r55c"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2019-10-20"
url = "https://github.com/google/flatbuffers/issues/5530"

[affected.functions]
"flatbuffers::Follow::follow" = [">= 0.4.0", "<= 0.6.0"]

[versions]
patched = [">= 0.6.1"]
unaffected = ["< 0.4.0"]
```

# Unsound `impl Follow for bool`

The implementation of `impl Follow for bool` allows to reinterpret arbitrary bytes as a `bool`.

In Rust `bool` has stringent requirements for its in-memory representation. Use of this function
allows to violate these requirements and invoke undefined behaviour in safe code.
