```toml
[advisory]
id = "RUSTSEC-2024-0379"
package = "fast-float"
date = "2024-10-31"
informational = "unsound"
url = "https://github.com/aldanor/fast-float-rust/issues/35"
references = ["https://github.com/aldanor/fast-float-rust/issues/28", "https://github.com/aldanor/fast-float-rust/issues/37"]
aliases = []

[versions]
patched = []
```

# Multiple soundness issues

`fast-float` contains multiple soundness issues:

 1. [Undefined behavior when checking input length](https://github.com/aldanor/fast-float-rust/issues/28), which has been merged but no package [pubished](https://github.com/aldanor/fast-float-rust/issues/35).
 1. [Many functions marked as safe with non-local safety guarantees](https://github.com/aldanor/fast-float-rust/issues/37)

The library is also unmaintained.

## Alternatives

For quickly parsing floating-point numbers third-party crates are generally no longer needed. A fast float parsing algorithm by the author of `lexical` has been [merged](https://github.com/rust-lang/rust/pull/86761) into libcore. When requiring direct parsing from bytes and/or partial parsers, the [`fast-float2`](https://crates.io/crates/fast-float2) fork of `fast-float` containing these security patches and reduces overall usage of unsafe.
