```toml
[advisory]
id = "RUSTSEC-2022-0083"
package = "evm"
date = "2022-10-25"
url = "https://github.com/rust-blockchain/evm/pull/133"
aliases = ["CVE-2022-39354", "GHSA-hhc4-47rh-cr34"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N"
categories = ["crypto-failure"]

[versions]
patched = [">= 0.36.0"]
```

# evm incorrect state transition

SputnikVM, also called evm, is a Rust implementation of Ethereum Virtual Machine.

A custom stateful precompile can use the `is_static` parameter to determine if
the call is executed in a static context (via `STATICCALL`), and thus decide
if stateful operations should be done.

Prior to version 0.36.0, the passed `is_static` parameter was incorrect -- it
was only set to `true` if the call came from a direct `STATICCALL` opcode.

However, once a static call context is entered, it should stay static. The issue
only impacts custom precompiles that actually uses `is_static`.

For those affected, the issue can lead to possible incorrect state transitions.
