```toml
[advisory]
id = "RUSTSEC-2021-0066"
package = "evm-core"
date = "2021-05-11"
url = "https://github.com/rust-blockchain/evm"
categories = ["denial-of-service"]
aliases = ["GHSA-773q-5334-5gf9"]

[versions]
patched = [">= 0.26.1", "0.25.1", "0.24.1", "0.23.1", "0.21.1"]
```

# Denial of service on EVM execution due to memory over-allocation

Prior to the patch, when executing specific EVM opcodes related
to memory operations that use `evm_core::Memory::copy_large`, the
crate can over-allocate memory when it is not needed, making it
possible for an attacker to perform denial-of-service attack.

The flaw was corrected in commit `19ade85`.
