```toml
[advisory]
id = "RUSTSEC-2020-0108"
package = "eventio"
aliases = ["CVE-2020-36216", "GHSA-69vj-xx27-g45w"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-12-20"
url = "https://github.com/petabi/eventio/issues/33"
categories = ["memory-corruption", "thread-safety"]

[versions]
patched = [">= 0.5.1"]
```

# Soundness issue: Input<R> can be misused to create data race to an object

`Input<R>` implements `Send` without requiring `R: Send`.

Affected versions of this crate allows users to send non-Send types to other threads,
which can lead to undefined behavior such as data race and memory corruption.

The flaw was corrected in version 0.5.1 by adding `R: Send` bound to the `Send` impl of `Input<R>`.
