```toml
[advisory]
id = "RUSTSEC-2021-0037"
package = "diesel"
aliases = ["CVE-2021-28305", "GHSA-j8q9-5rp9-4mv9"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-03-05"
url = "https://github.com/diesel-rs/diesel/pull/2663"
categories = ["memory-corruption"]
keywords = ["use after free"]

[affected]
functions = { "diesel::SqliteConnection::query_by_name" = ["< 1.4.6"] }
[versions]
patched = [">= 1.4.6"]
```

# Fix a use-after-free bug in diesels Sqlite backend

We've misused `sqlite3_column_name`. The
[SQLite](https://www.sqlite.org/c3ref/column_name.html) documentation
states that the following:

> The returned string pointer is valid until either the prepared statement
> is destroyed by sqlite3_finalize() or until the statement is automatically
> reprepared by the first call to sqlite3_step() for a particular
> run or until the next call to sqlite3_column_name()
> or sqlite3_column_name16() on the same column.

As part of our `query_by_name` infrastructure we've first received all
field names for the prepared statement and stored them as string slices
for later use. After that we called `sqlite3_step()` for the first time,
which invalids the pointer and therefore the stored string slice.
