```toml
[advisory]
id = "RUSTSEC-2021-0083"
package = "derive-com-impl"
date = "2021-01-20"
url = "https://github.com/Connicpu/com-impl/issues/1"
categories = ["memory-corruption"]
keywords = ["com", "queryinterface", "addref"]
aliases = ["CVE-2021-45681", "GHSA-9rg7-3j4f-cf4x", "GHSA-w4cc-pc2h-whcj"]

[affected]
functions = { "derive_com_impl::derive_com_impl" = ["<= 0.1.1"] }

[versions]
patched = [">= 0.1.2"]
```

# QueryInterface should call AddRef before returning pointer

Affected version of this crate, which is a required dependency in com-impl, 
provides a faulty implementation of the `IUnknown::QueryInterface` method.

`QueryInterface` implementation must call `IUnknown::AddRef` before returning the pointer,
as describe in this documentation:
<https://docs.microsoft.com/en-us/windows/win32/api/unknwn/nf-unknwn-iunknown-queryinterface(refiid_void)>

As it is not incrementing the refcount as expected, the following calls to `IUnknown::Release` method 
will cause WMI to drop reference to the interface, and can lead to invalid reference.

This is documented in <https://docs.microsoft.com/en-us/windows/win32/learnwin32/managing-the-lifetime-of-an-object#reference-counting>

There is no simple workaround, as you can't know how many time QueryInterface will be called.
The only way to quick fix this is to use the macro expanded version of the code and modify 
the QueryInterface method to add the AddRef call yourself.

The issue was corrected in commit `9803f31fbd1717d482d848f041044d061fca6da7`.
