```toml
[advisory]
id = "RUSTSEC-2020-0101"
package = "conquer-once"
aliases = ["CVE-2020-36208", "GHSA-3jc5-5hc5-33gj"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H"
date = "2020-12-22"
url = "https://github.com/oliver-giersch/conquer-once/issues/3"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]

[versions]
patched = [">= 0.3.2"]
unaffected = []
```

# conquer-once's OnceCell lacks Send bound for its Sync trait.

Affected versions of `conquer-once` implements `Sync` for its `OnceCell` type
without restricting it to `Send`able types.

This allows non-`Send` but `Sync` types such as `MutexGuard` to be sent across
threads leading to undefined behavior and memory corruption in concurrent
programs.

The issue was fixed by adding a `Send` constraint to `OnceCell`.
