```toml
[advisory]
id = "RUSTSEC-2019-0015"
package = "compact_arena"
aliases = ["CVE-2019-16139", "GHSA-7j36-gc4r-9x3r"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2019-05-21"
keywords = ["uninitialized-memory"]
url = "https://github.com/llogiq/compact_arena/issues/22"

[affected.functions]
"compact_arena::SmallArena::new" = ["< 0.4.0"]

[versions]
patched = [">= 0.4.0"]
```

# Flaw in generativity allows out-of-bounds access

Affected versions of this crate did not properly implement the generativity,
because the invariant lifetimes were not necessarily `drop`ped.

This allows an attacker to mix up two arenas, using indices created from one
arena with another one. This might lead to an out-of-bounds read or write
access into the memory reserved for the arena.

The flaw was corrected by implementing generativity correctly in version 0.4.0.
