```toml
[advisory]
id = "RUSTSEC-2018-0004"
package = "claxon"
aliases = ["CVE-2018-20992", "GHSA-8c6g-4xc5-w96c"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N"
date = "2018-08-25"
keywords = ["uninitialized-memory"]
url = "https://github.com/ruuda/claxon/commit/8f28ec275e412dd3af4f3cda460605512faf332c"

[versions]
patched = ["^0.3.2", ">= 0.4.1"]
```

# Malicious input could cause uninitialized memory to be exposed

Affected versions of Claxon made an invalid assumption about the decode buffer
size being a multiple of a value read from the bitstream. This could cause parts
of the decode buffer to not be overwritten. If the decode buffer was newly
allocated and uninitialized, this uninitialized memory could be exposed.

This allows an attacker to observe parts of the uninitialized memory in the
decoded audio stream.

The flaw was corrected by checking that the value read from the bitstream divides
the decode buffer size, and returning a format error if it does not. If an error
is returned, the decode buffer is not exposed. Regression tests and an
additional fuzzer have been added to prevent similar flaws in the future.
