```toml
[advisory]
id = "RUSTSEC-2022-0068"
package = "capnp"
date = "2022-11-30"
url = "https://github.com/capnproto/capnproto/tree/master/security-advisories/2022-11-30-0-pointer-list-bounds.md"
references = ["https://dwrensha.github.io/capnproto-rust/2022/11/30/out_of_bounds_memory_access_bug.html", "https://github.com/capnproto/capnproto/security/advisories/GHSA-qqff-4vw4-f6hx"]
categories = ["memory-exposure"]
aliases = ["CVE-2022-46149", "GHSA-qqff-4vw4-f6hx"]

[versions]
patched = [">= 0.15.2", "^0.14.11", "^0.13.7"]
```

# out-of-bounds read possible when setting list-of-pointers

If a message consumer expects data
of type "list of pointers",
and if the consumer performs certain specific actions on such data,
then a message producer can cause the consumer to read out-of-bounds memory.
This could trigger a process crash in the consumer,
or in some cases could allow exfiltration of private in-memory data.

The C++ Cap'n Proto library is also affected by this bug.
See the [advisory](https://github.com/capnproto/capnproto/tree/master/security-advisories/2022-11-30-0-pointer-list-bounds.md)
on the main Cap'n Proto repo for a succinct description of
the exact circumstances in which the problem can arise.
