```toml
[advisory]
id = "RUSTSEC-2020-0128"
package = "cache"
date = "2020-11-24"
url = "https://github.com/krl/cache/issues/1"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36448", "GHSA-g78p-g85h-q6ww"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# Cache<K>: Send/Sync impls needs trait bounds on `K`

Affected versions of this crate unconditionally implement Send/Sync for `Cache<K>`.
This allows users to insert `K` that is not Send or not Sync.

This allows users to create data races by using non-Send types like `Arc<Cell<T>>` or `Rc<T>` as `K` in `Cache<K>`. It is also possible to create data races by using types like `Cell<T>` or `RefCell<T>` (types that are `Send` but not `Sync`).
Such data races can lead to memory corruption.
