```toml
[advisory]
id = "RUSTSEC-2023-0004"
package = "bzip2"
aliases = ["CVE-2023-22895", "GHSA-96jv-r488-c2rj"]
date = "2023-01-09"
url = "https://github.com/alexcrichton/bzip2-rs/pull/86"
categories = ["denial-of-service"]

[versions]
patched = [">= 0.4.4"]

```

# bzip2 Denial of Service (DoS)

Working with specific payloads can cause a Denial of Service (DoS) vector.

Both `Decompress` and `Compress` implementations can enter into infinite loops
given specific payloads entered that trigger it.

The issue is described in great detail in the [bzip2 repository issue](https://github.com/alexcrichton/bzip2-rs/pull/86).

Thanks to bjrjk for finding and providing the patch for the issue and the
maintainer responsibly responding to release a fix quickly.

Users who use the crate with untrusted data should update the `bzip2` to 0.4.4.
