```toml
[advisory]
id = "RUSTSEC-2023-0083"

package = "blurhash"
date = "2023-09-19"
url = "https://github.com/whisperfish/blurhash-rs/security/advisories/GHSA-cxvp-82cq-57h2"
references = ["https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-42447"]
categories = ["denial-of-service"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H"
keywords = ["panic", "untrusted input", "parsing"]
aliases = ["CVE-2023-42447", "cxvp-82cq-57h2"]

[affected]
functions = { "blurhash::decode" = ["*"] }

[versions]
patched = [">= 0.2.0"]
```

# blurhash: panic on parsing crafted blurhash inputs

## Impact
The blurhash parsing code may panic due to multiple panic-guarded out-of-bounds accesses on untrusted input.

In a typical deployment, this may get triggered by feeding a maliciously crafted blurhashes over the network. These may include:
- UTF-8 compliant strings containing multi-byte UTF-8 characters

## Patches
The patches were released under version 0.2.0, which may require user intervention because of slight API churn.
