```toml
[advisory]
id = "RUSTSEC-2019-0019"
package = "blake2"
aliases = ["CVE-2019-16143", "GHSA-4x25-pvhw-5224"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["crypto-failure"]
date = "2019-08-25"
url = "https://github.com/RustCrypto/MACs/issues/19"

[versions]
patched = [">= 0.8.1"]
```

# HMAC-BLAKE2 algorithms compute incorrect results

When used in conjunction with the Hash-based Message Authentication Code (HMAC),
the BLAKE2b and BLAKE2s implementations in `blake2` crate versions prior to
v0.8.1 used an incorrect block size (32-bytes instead of 64-bytes for BLAKE2s,
and 64-bytes instead of 128-bytes for BLAKE2b), causing them to miscompute the
`MacResult`.

The v0.8.1 release of the `blake2` crate uses the correct block sizes.

Note that this advisory only impacts usage of BLAKE2 with HMAC, and does not
impact `Digest` functionality.
