```toml
[advisory]
id = "RUSTSEC-2020-0122"
package = "beef"
date = "2020-10-28"
url = "https://github.com/maciejhirsz/beef/issues/37"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36442", "GHSA-m7w4-8wp8-m2xq"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.5.0"]
```

# beef::Cow lacks a Sync bound on its Send trait allowing for data races

Affected versions of this crate did not have a `T: Sync` bound in the `Send` impl for `Cow<'_, T, U>`. This allows users to create data races by making `Cow` contain types that are (Send && !Sync) like `Cell<_>` or `RefCell<_>`.

Such data races can lead to memory corruption.

The flaw was corrected in commit d1c7658 by adding trait bounds `T: Sync` and `T::Owned: Send` to the `Send` impl for `Cow<'_, T, U>`.
