```toml
[advisory]
id = "RUSTSEC-2020-0113"
package = "atomic-option"
aliases = ["CVE-2020-36219", "GHSA-8gf5-q9p9-wvmc"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-10-31"
url = "https://github.com/reem/rust-atomic-option/issues/4"
categories = ["memory-corruption", "thread-safety"]

[versions]
patched = []
```

# AtomicOption should have Send + Sync bound on its type argument.

In the affected versions of this crate,
`AtomicOption<T>` unconditionally implements `Sync`.

This allows programmers to move non-Sync types across thread boundaries (e.g. `Rc<T>`, `Arc<Cell<T>>`), which can lead to data races and undefined behavior. 
It is also possible to send non-Send types like `std::sync::MutexGuard` to other threads, which can lead to undefined behavior.
