```toml
[advisory]
id = "RUSTSEC-2020-0091"
package = "arc-swap"
date = "2020-12-10"
url = "https://github.com/vorner/arc-swap/issues/45"
categories = ["memory-corruption"]
keywords = ["dangling reference"]
aliases = ["CVE-2020-35711", "GHSA-9pqx-g3jh-qpqq"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 0.4.8, < 1.0.0-0", ">= 1.1.0"]
unaffected = ["< 0.4.2"]

[affected]
functions = { "arc_swap::access::MapGuard::deref" = ["< 1.1.0"] }
```

# Dangling reference in `access::Map` with Constant

Using the `arc_swap::access::Map` with the `Constant` test helper (or with
user-provided implementation of the `Access` trait) could sometimes lead to the
map returning dangling references.

Replaced by implementation without `unsafe`, at the cost of added `Clone` bound
on the closure and small penalty on performance.
