```toml
[advisory]
id = "RUSTSEC-2021-0059"
package = "aesni"
date = "2021-04-29"
informational = "unmaintained"
url = "https://github.com/RustCrypto/block-ciphers/pull/200"

[versions]
patched = []
unaffected = []
```

# `aesni` has been merged into the `aes` crate

Please use the `aes` crate going forward. The new repository location is at:

<https://github.com/RustCrypto/block-ciphers/tree/master/aes>

AES-NI is now autodetected at runtime on `i686`/`x86-64` platforms.
If AES-NI is not present, the `aes` crate will fallback to a constant-time
portable software implementation.

To prevent this fallback (and have absence of AES-NI result in an illegal
instruction crash instead), continue to pass the same RUSTFLAGS which were
previously required for the `aesni` crate to compile:

```
RUSTFLAGS=-Ctarget-feature=+aes,+ssse3
```
