// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// APIServerConfigApplyConfiguration represents an declarative configuration of the APIServerConfig type for use
// with apply.
type APIServerConfigApplyConfiguration struct {
	Host            *string                          `json:"host,omitempty"`
	BasicAuth       *BasicAuthApplyConfiguration     `json:"basicAuth,omitempty"`
	BearerTokenFile *string                          `json:"bearerTokenFile,omitempty"`
	TLSConfig       *TLSConfigApplyConfiguration     `json:"tlsConfig,omitempty"`
	Authorization   *AuthorizationApplyConfiguration `json:"authorization,omitempty"`
	BearerToken     *string                          `json:"bearerToken,omitempty"`
}

// APIServerConfigApplyConfiguration constructs an declarative configuration of the APIServerConfig type for use with
// apply.
func APIServerConfig() *APIServerConfigApplyConfiguration {
	return &APIServerConfigApplyConfiguration{}
}

// WithHost sets the Host field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Host field is set to the value of the last call.
func (b *APIServerConfigApplyConfiguration) WithHost(value string) *APIServerConfigApplyConfiguration {
	b.Host = &value
	return b
}

// WithBasicAuth sets the BasicAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BasicAuth field is set to the value of the last call.
func (b *APIServerConfigApplyConfiguration) WithBasicAuth(value *BasicAuthApplyConfiguration) *APIServerConfigApplyConfiguration {
	b.BasicAuth = value
	return b
}

// WithBearerTokenFile sets the BearerTokenFile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BearerTokenFile field is set to the value of the last call.
func (b *APIServerConfigApplyConfiguration) WithBearerTokenFile(value string) *APIServerConfigApplyConfiguration {
	b.BearerTokenFile = &value
	return b
}

// WithTLSConfig sets the TLSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLSConfig field is set to the value of the last call.
func (b *APIServerConfigApplyConfiguration) WithTLSConfig(value *TLSConfigApplyConfiguration) *APIServerConfigApplyConfiguration {
	b.TLSConfig = value
	return b
}

// WithAuthorization sets the Authorization field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Authorization field is set to the value of the last call.
func (b *APIServerConfigApplyConfiguration) WithAuthorization(value *AuthorizationApplyConfiguration) *APIServerConfigApplyConfiguration {
	b.Authorization = value
	return b
}

// WithBearerToken sets the BearerToken field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BearerToken field is set to the value of the last call.
func (b *APIServerConfigApplyConfiguration) WithBearerToken(value string) *APIServerConfigApplyConfiguration {
	b.BearerToken = &value
	return b
}
