# Profile Context

> [!NOTE]
> This documentation applies only to version `0.124.0` and later. Information on earlier versions is not available.

The Profile Context is a Context implementation for [pdata Profiles](https://github.com/open-telemetry/opentelemetry-collector/tree/main/pdata/pprofile), the collector's internal representation for OTLP profile data.  This Context should be used when interacted with OTLP profiles.

## Paths
In general, the Profile Context supports accessing pdata using the field names from the [profiles proto](https://github.com/open-telemetry/opentelemetry-proto/blob/main/opentelemetry/proto/profiles/v1development/profiles.proto).  All integers are returned and set via `int64`.  All doubles are returned and set via `float64`.

The following paths are supported.

| path                                     | field accessed                                                                                                                                     | type                                                                    |
|------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------|
| cache                                    | the value of the current transform context's temporary cache. cache can be used as a temporary placeholder for data during complex transformations | pcommon.Map                                                             |
| cache\[""\]                              | the value of an item in cache. Supports multiple indexes to access nested fields.                                                                  | string, bool, int64, float64, pcommon.Map, pcommon.Slice, []byte or nil |
| resource                                 | resource of the profile being processed                                                                                                            | pcommon.Resource                                                        |
| resource.attributes                      | resource attributes of the profile being processed                                                                                                 | pcommon.Map                                                             |
| resource.attributes\[""\]                | the value of the resource attribute of the profile being processed. Supports multiple indexes to access nested fields.                             | string, bool, int64, float64, pcommon.Map, pcommon.Slice, []byte or nil |
| instrumentation_scope                    | instrumentation scope of the profile being processed                                                                                               | pcommon.InstrumentationScope                                            |
| instrumentation_scope.name               | name of the instrumentation scope of the profile being processed                                                                                   | string                                                                  |
| instrumentation_scope.version            | version of the instrumentation scope of the profile being processed                                                                                | string                                                                  |
| instrumentation_scope.attributes         | instrumentation scope attributes of the data point being processed                                                                                 | pcommon.Map                                                             |
| instrumentation_scope.attributes\[""\]   | the value of the instrumentation scope attribute of the data point being processed. Supports multiple indexes to access nested fields.             | string, bool, int64, float64, pcommon.Map, pcommon.Slice, []byte or nil |
| profile.sample_type                      | the sample types of the profile being processed                                                                                                    | pprofile.ValueTypeSlice                                                 |
| profile.sample                           | the samples of the profile being processed                                                                                                         | pprofile.SampleSlice                                                    |
| profile.mapping_table                    | the mapping table of the profile being processed                                                                                                   | pprofile.MappingSlice                                                   |
| profile.location_table                   | the location table of the profile being processed                                                                                                  | pprofile.LocationSlice                                                  |
| profile.location_indices                 | the location indices of the profile being processed                                                                                                | []int64                                                                 |
| profile.function_table                   | the function table of the profile being processed                                                                                                  | pprofile.FunctionSlice                                                  |
| profile.attribute_table                  | the attribute table of the profile being processed                                                                                                 | pprofile.AttributeTableSlice                                            |
| profile.attribute_units                  | the attribute units of the profile being processed                                                                                                 | pprofile.AttributeUnitSlice                                             |
| profile.link_table                       | the link table of the profile being processed                                                                                                      | pprofile.LinkSlice                                                      |
| profile.string_table                     | the string table of the profile being processed                                                                                                    | []string                                                                |
| profile.time_unix_nano                   | the time in unix nano of the profile being processed                                                                                               | int64                                                                   |
| profile.time                             | the time in `time.Time` of the profile being processed                                                                                             | time.Time                                                               |
| profile.duration_unix_nano               | the duration in unix nano of the profile being processed                                                                                           | int64                                                                   |
| profile.duration                         | the duration in nanoseconds of the profile being processed                                                                                         | time.Time                                                               |
| profile.period_type                      | the period type of the profile being processed                                                                                                     | pprofile.ValueType                                                      |
| profile.period                           | the period of the profile being processed                                                                                                          | int64                                                                   |
| profile.comment_string_indices           | the comment string indices of the profile being processed                                                                                          | []int64                                                                 |
| profile.default_sample_type_string_index | the default sample type string index of the profile being processed                                                                                | int64                                                                   |
| profile.profile_id                       | the profile id of the profile being processed                                                                                                      | pprofile.ProfileID                                                      |
| profile.profile_id.string                | a string representation of the profile id                                                                                                          | string                                                                  |
| profile.attribute_indices                | the attribute indices of the profile being processed                                                                                               | []int64                                                                 |
| profile.dropped_attributes_count         | the dropped attributes count of the profile being processed                                                                                        | int64                                                                   |
| profile.original_payload_format          | the original payload format of the profile being processed                                                                                         | string                                                                  |
| profile.original_payload                 | the original payload of the profile being processed                                                                                                | []byte                                                                  |
