# AWS S3 Exporter for OpenTelemetry Collector

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [alpha]: traces, metrics, logs   |
| Distributions | [contrib] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Aexporter%2Fawss3%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Aexporter%2Fawss3) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Aexporter%2Fawss3%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Aexporter%2Fawss3) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@atoulme](https://www.github.com/atoulme), [@pdelewski](https://www.github.com/pdelewski), [@Erog38](https://www.github.com/Erog38) |

[alpha]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#alpha
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
<!-- end autogenerated section -->

## Schema supported
This exporter targets to support proto/json format.

## Exporter Configuration

The following exporter configuration parameters are supported.

| Name                      | Description                                                                                                                                | Default                                     |
|:--------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
| `region`                  | AWS region.                                                                                                                                | "us-east-1"                                 |
| `s3_bucket`               | S3 bucket                                                                                                                                  |                                             |
| `s3_prefix`               | prefix for the S3 key (root directory inside bucket).                                                                                      |                                             |
| `s3_partition_format`     | filepath formatting for the partition; See [strftime](https://www.man7.org/linux/man-pages/man3/strftime.3.html) for format specification. | "year=%Y/month=%m/day=%d/hour=%H/minute=%M" |
| `role_arn`                | the Role ARN to be assumed                                                                                                                 |                                             |
| `file_prefix`             | file prefix defined by user                                                                                                                |                                             |
| `marshaler`               | marshaler used to produce output data                                                                                                      | `otlp_json`                                 |
| `encoding`                | Encoding extension to use to marshal data. Overrides the `marshaler` configuration option if set.                                          |                                             |
| `encoding_file_extension` | file format extension suffix when using the `encoding` configuration option. May be left empty for no suffix to be appended.               |                                             |
| `endpoint`                | (REST API endpoint) overrides the endpoint used by the exporter instead of constructing it from `region` and `s3_bucket`                   |                                             |
| `storage_class`           | [S3 storageclass](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html)                                          | STANDARD                                    |
| `acl`                     | [S3 Object Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl)                                 | none (does not set by default)              |
| `s3_force_path_style`     | [set this to `true` to force the request to use path-style addressing](http://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html) | false                                       |
| `disable_ssl`             | set this to `true` to disable SSL when sending requests                                                                                    | false                                       |
| `compression`             | should the file be compressed                                                                                                              | none                                        |
| `sending_queue`           | [exporters common queuing](https://github.com/open-telemetry/opentelemetry-collector/blob/main/exporter/exporterhelper/README.md)          | disabled                                    |
| `timeout`                 | [exporters common timeout](https://github.com/open-telemetry/opentelemetry-collector/blob/main/exporter/exporterhelper/README.md)          | 5s                                          |
| `resource_attrs_to_s3`        | determines the mapping of S3 configuration values to resource attribute values for uploading operations.                                   |                                             |

### Marshaler

Marshaler determines the format of data sent to AWS S3. Currently, the following marshalers are implemented:

- `otlp_json` (default): the [OpenTelemetry Protocol format](https://github.com/open-telemetry/opentelemetry-proto), represented as json.
- `otlp_proto`: the [OpenTelemetry Protocol format](https://github.com/open-telemetry/opentelemetry-proto), represented as Protocol Buffers. A single protobuf message is written into each object.
- `sumo_ic`: the [Sumo Logic Installed Collector Archive format](https://help.sumologic.com/docs/manage/data-archiving/archive/).
  **This format is supported only for logs.**
- `body`: export the log body as string.
  **This format is supported only for logs.**

### Encoding

Encoding overrides marshaler if present and sets to use an encoding extension defined in the collector configuration.

See https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/encoding.

### Compression
- `none` (default): No compression will be applied
- `gzip`: Files will be compressed with gzip. **This does not support `sumo_ic`marshaler.**

### resource_attrs_to_s3
- `s3_prefix`: Defines which resource attribute's value should be used as the S3 prefix.
  When this option is set, it dynamically overrides `s3uploader/s3_prefix`. 
  If the specified resource attribute exists in the data,  
  its value will be used as the prefix; otherwise, `s3uploader/s3_prefix` will serve as the fallback.

# Example Configurations

Following example configuration defines to store output in 'eu-central' region and bucket named 'databucket'.

```yaml
exporters:
  awss3:
    s3uploader:
      region: 'eu-central-1'
      s3_bucket: 'databucket'
      s3_prefix: 'metric'

    # Optional (disabled by default)
    sending_queue:
      enabled: true
      num_consumers: 10
      queue_size: 100

    # Optional (5s by default)
    timeout: 20s      
```

Logs and traces will be stored inside 'databucket' in the following path format.

```console
metric/year=YYYY/month=MM/day=DD/hour=HH/minute=mm
```

## Partition Formatting

By setting the `s3_partition_format` option, users can specify the file path for their logs.
See the [strftime](https://www.man7.org/linux/man-pages/man3/strftime.3.html) reference for more formatting options.

```yaml
exporters:
  awss3:
    s3uploader:
      region: 'eu-central-1'
      s3_bucket: 'databucket'
      s3_prefix: 'metric'
      s3_partition_format: '%Y/%m/%d/%H/%M'
```

In this case, logs and traces would be stored in the following path format.

```console
metric/YYYY/MM/DD/HH/mm
```

## Data routing based on resource attributes
When `resource_attrs_to_s3/s3_prefix` is configured, the S3 prefix is dynamically derived from a specified resource attribute in your data.
If the attribute value is unavailable, the prefix will fall back to the value defined in `s3uploader/s3_prefix`.
```yaml
exporters:
  awss3:
    s3uploader:
      region: 'eu-central-1'
      s3_bucket: 'databucket'
      s3_prefix: 'metric'
      s3_partition_format: '%Y/%m/%d/%H/%M'
    resource_attrs_to_s3:
      s3_prefix: "com.awss3.prefix"
```
In this case, metrics, logs and traces would be stored in the following path format examples:

```console
prefix1/YYYY/MM/DD/HH/mm
foo-prefix/YYYY/MM/DD/HH/mm
prefix-bar/YYYY/MM/DD/HH/mm
metric/YYYY/MM/DD/HH/mm
...
```


## AWS Credential Configuration

This exporter follows default credential resolution for the
[aws-sdk-go](https://docs.aws.amazon.com/sdk-for-go/api/index.html).

Follow the [guidelines](https://docs.aws.amazon.com/sdk-for-go/v1/developer-guide/configuring-sdk.html) for the
credential configuration.

### OpenTelemetry Collector Helm Chart for Kubernetes
For example, when using OpenTelemetry Collector Helm Chart you could use `extraEnvs` in the values.yaml.
```yaml
extraEnvs:
- name: AWS_ACCESS_KEY_ID
  value: "< YOUR AWS ACCESS KEY >"
- name: AWS_SECRET_ACCESS_KEY
  value: "< YOUR AWS SECRET ACCESS KEY >"
```
