// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package watcher

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpfWatchInfoT struct {
	Flags   uint64
	Payload uint64
}

// loadBpf returns the embedded CollectionSpec for bpf.
func loadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf: %w", err)
	}

	return spec, err
}

// loadBpfObjects loads bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpfObjects
//	*bpfPrograms
//	*bpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfSpecs struct {
	bpfProgramSpecs
	bpfMapSpecs
	bpfVariableSpecs
}

// bpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfProgramSpecs struct {
	BeylaKprobeSysBind *ebpf.ProgramSpec `ebpf:"beyla_kprobe_sys_bind"`
}

// bpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfMapSpecs struct {
	WatchEvents *ebpf.MapSpec `ebpf:"watch_events"`
}

// bpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfVariableSpecs struct {
	Ip4ip6Prefix *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.VariableSpec `ebpf:"unused"`
	Unused2      *ebpf.VariableSpec `ebpf:"unused_2"`
	UnusedHttp2  *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// bpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfObjects struct {
	bpfPrograms
	bpfMaps
	bpfVariables
}

func (o *bpfObjects) Close() error {
	return _BpfClose(
		&o.bpfPrograms,
		&o.bpfMaps,
	)
}

// bpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfMaps struct {
	WatchEvents *ebpf.Map `ebpf:"watch_events"`
}

func (m *bpfMaps) Close() error {
	return _BpfClose(
		m.WatchEvents,
	)
}

// bpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfVariables struct {
	Ip4ip6Prefix *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.Variable `ebpf:"unused"`
	Unused2      *ebpf.Variable `ebpf:"unused_2"`
	UnusedHttp2  *ebpf.Variable `ebpf:"unused_http2"`
}

// bpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfPrograms struct {
	BeylaKprobeSysBind *ebpf.Program `ebpf:"beyla_kprobe_sys_bind"`
}

func (p *bpfPrograms) Close() error {
	return _BpfClose(
		p.BeylaKprobeSysBind,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
