// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package tctracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpf_debugConnectionInfoT struct {
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type bpf_debugEgressKeyT struct {
	S_port uint16
	D_port uint16
}

type bpf_debugGoAddrKeyT struct {
	Pid  uint64
	Addr uint64
}

type bpf_debugHttpFuncInvocationT struct {
	StartMonotimeNs uint64
	Tp              struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type bpf_debugHttpInfoT struct {
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        bpf_debugConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len     uint32
	RespLen uint32
	TaskTid uint32
	Status  uint16
	Buf     [256]uint8
	Pad     [6]uint8
}

type bpf_debugPidConnectionInfoT struct {
	Conn bpf_debugConnectionInfoT
	Pid  uint32
}

type bpf_debugTpInfoPidT struct {
	Tp struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type bpf_debugTraceMapKeyT struct {
	Conn bpf_debugConnectionInfoT
	Type uint32
}

// loadBpf_debug returns the embedded CollectionSpec for bpf_debug.
func loadBpf_debug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_Bpf_debugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf_debug: %w", err)
	}

	return spec, err
}

// loadBpf_debugObjects loads bpf_debug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpf_debugObjects
//	*bpf_debugPrograms
//	*bpf_debugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpf_debugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf_debug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpf_debugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugSpecs struct {
	bpf_debugProgramSpecs
	bpf_debugMapSpecs
	bpf_debugVariableSpecs
}

// bpf_debugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugProgramSpecs struct {
	BeylaAppEgress  *ebpf.ProgramSpec `ebpf:"beyla_app_egress"`
	BeylaAppIngress *ebpf.ProgramSpec `ebpf:"beyla_app_ingress"`
}

// bpf_debugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugMapSpecs struct {
	DebugEvents                 *ebpf.MapSpec `ebpf:"debug_events"`
	GoOngoingHttp               *ebpf.MapSpec `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests *ebpf.MapSpec `ebpf:"go_ongoing_http_client_requests"`
	IncomingTraceMap            *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	OngoingHttp                 *ebpf.MapSpec `ebpf:"ongoing_http"`
	OutgoingTraceMap            *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	SockDir                     *ebpf.MapSpec `ebpf:"sock_dir"`
	TraceMap                    *ebpf.MapSpec `ebpf:"trace_map"`
}

// bpf_debugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugVariableSpecs struct {
	EXTEND_SIZE       *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX         *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2       *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// bpf_debugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugObjects struct {
	bpf_debugPrograms
	bpf_debugMaps
	bpf_debugVariables
}

func (o *bpf_debugObjects) Close() error {
	return _Bpf_debugClose(
		&o.bpf_debugPrograms,
		&o.bpf_debugMaps,
	)
}

// bpf_debugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugMaps struct {
	DebugEvents                 *ebpf.Map `ebpf:"debug_events"`
	GoOngoingHttp               *ebpf.Map `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests *ebpf.Map `ebpf:"go_ongoing_http_client_requests"`
	IncomingTraceMap            *ebpf.Map `ebpf:"incoming_trace_map"`
	OngoingHttp                 *ebpf.Map `ebpf:"ongoing_http"`
	OutgoingTraceMap            *ebpf.Map `ebpf:"outgoing_trace_map"`
	SockDir                     *ebpf.Map `ebpf:"sock_dir"`
	TraceMap                    *ebpf.Map `ebpf:"trace_map"`
}

func (m *bpf_debugMaps) Close() error {
	return _Bpf_debugClose(
		m.DebugEvents,
		m.GoOngoingHttp,
		m.GoOngoingHttpClientRequests,
		m.IncomingTraceMap,
		m.OngoingHttp,
		m.OutgoingTraceMap,
		m.SockDir,
		m.TraceMap,
	)
}

// bpf_debugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugVariables struct {
	EXTEND_SIZE       *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX         *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.Variable `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2       *ebpf.Variable `ebpf:"unused_http2"`
}

// bpf_debugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugPrograms struct {
	BeylaAppEgress  *ebpf.Program `ebpf:"beyla_app_egress"`
	BeylaAppIngress *ebpf.Program `ebpf:"beyla_app_ingress"`
}

func (p *bpf_debugPrograms) Close() error {
	return _Bpf_debugClose(
		p.BeylaAppEgress,
		p.BeylaAppIngress,
	)
}

func _Bpf_debugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_debug_arm64_bpfel.o
var _Bpf_debugBytes []byte
