// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package gpuevent

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpfGpuKernelLaunchT struct {
	Flags   uint8
	Pad     [3]uint8
	PidInfo struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	KernFuncOff uint64
	GridX       int32
	GridY       int32
	GridZ       int32
	BlockX      int32
	BlockY      int32
	BlockZ      int32
	Stream      uint64
	Args        [16]uint64
	UstackSz    uint64
	Ustack      [128]uint64
}

type bpfGpuMallocT struct {
	Flags   uint8
	Pad     [3]uint8
	PidInfo struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Size uint64
}

// loadBpf returns the embedded CollectionSpec for bpf.
func loadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf: %w", err)
	}

	return spec, err
}

// loadBpfObjects loads bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpfObjects
//	*bpfPrograms
//	*bpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfSpecs struct {
	bpfProgramSpecs
	bpfMapSpecs
	bpfVariableSpecs
}

// bpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfProgramSpecs struct {
	HandleCudaLaunch *ebpf.ProgramSpec `ebpf:"handle_cuda_launch"`
	HandleCudaMalloc *ebpf.ProgramSpec `ebpf:"handle_cuda_malloc"`
}

// bpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfMapSpecs struct {
	PidCache  *ebpf.MapSpec `ebpf:"pid_cache"`
	Rb        *ebpf.MapSpec `ebpf:"rb"`
	ValidPids *ebpf.MapSpec `ebpf:"valid_pids"`
}

// bpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfVariableSpecs struct {
	FilterPids *ebpf.VariableSpec `ebpf:"filter_pids"`
	ProgCfg    *ebpf.VariableSpec `ebpf:"prog_cfg"`
	UnusedGpu  *ebpf.VariableSpec `ebpf:"unused_gpu"`
	UnusedGpu1 *ebpf.VariableSpec `ebpf:"unused_gpu1"`
}

// bpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfObjects struct {
	bpfPrograms
	bpfMaps
	bpfVariables
}

func (o *bpfObjects) Close() error {
	return _BpfClose(
		&o.bpfPrograms,
		&o.bpfMaps,
	)
}

// bpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfMaps struct {
	PidCache  *ebpf.Map `ebpf:"pid_cache"`
	Rb        *ebpf.Map `ebpf:"rb"`
	ValidPids *ebpf.Map `ebpf:"valid_pids"`
}

func (m *bpfMaps) Close() error {
	return _BpfClose(
		m.PidCache,
		m.Rb,
		m.ValidPids,
	)
}

// bpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfVariables struct {
	FilterPids *ebpf.Variable `ebpf:"filter_pids"`
	ProgCfg    *ebpf.Variable `ebpf:"prog_cfg"`
	UnusedGpu  *ebpf.Variable `ebpf:"unused_gpu"`
	UnusedGpu1 *ebpf.Variable `ebpf:"unused_gpu1"`
}

// bpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfPrograms struct {
	HandleCudaLaunch *ebpf.Program `ebpf:"handle_cuda_launch"`
	HandleCudaMalloc *ebpf.Program `ebpf:"handle_cuda_malloc"`
}

func (p *bpfPrograms) Close() error {
	return _BpfClose(
		p.HandleCudaLaunch,
		p.HandleCudaMalloc,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_arm64_bpfel.o
var _BpfBytes []byte
