// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/process/connections.proto

package process

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type RuntimeCompilationResult int32

const (
	RuntimeCompilationResult_NotAttempted        RuntimeCompilationResult = 0
	RuntimeCompilationResult_CompilationSuccess  RuntimeCompilationResult = 1
	RuntimeCompilationResult_KernelVersionErr    RuntimeCompilationResult = 2
	RuntimeCompilationResult_VerificationError   RuntimeCompilationResult = 3
	RuntimeCompilationResult_OutputDirErr        RuntimeCompilationResult = 4
	RuntimeCompilationResult_OutputFileErr       RuntimeCompilationResult = 5
	RuntimeCompilationResult_NewCompilerErr      RuntimeCompilationResult = 6
	RuntimeCompilationResult_CompilationErr      RuntimeCompilationResult = 7
	RuntimeCompilationResult_ResultReadErr       RuntimeCompilationResult = 8
	RuntimeCompilationResult_HeaderFetchErr      RuntimeCompilationResult = 9
	RuntimeCompilationResult_CompiledOutputFound RuntimeCompilationResult = 10
	RuntimeCompilationResult_InputHashError      RuntimeCompilationResult = 11
)

var RuntimeCompilationResult_name = map[int32]string{
	0:  "NotAttempted",
	1:  "CompilationSuccess",
	2:  "KernelVersionErr",
	3:  "VerificationError",
	4:  "OutputDirErr",
	5:  "OutputFileErr",
	6:  "NewCompilerErr",
	7:  "CompilationErr",
	8:  "ResultReadErr",
	9:  "HeaderFetchErr",
	10: "CompiledOutputFound",
	11: "InputHashError",
}

var RuntimeCompilationResult_value = map[string]int32{
	"NotAttempted":        0,
	"CompilationSuccess":  1,
	"KernelVersionErr":    2,
	"VerificationError":   3,
	"OutputDirErr":        4,
	"OutputFileErr":       5,
	"NewCompilerErr":      6,
	"CompilationErr":      7,
	"ResultReadErr":       8,
	"HeaderFetchErr":      9,
	"CompiledOutputFound": 10,
	"InputHashError":      11,
}

func (x RuntimeCompilationResult) String() string {
	return proto.EnumName(RuntimeCompilationResult_name, int32(x))
}

func (RuntimeCompilationResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{0}
}

type KernelHeaderFetchResult int32

const (
	KernelHeaderFetchResult_FetchNotAttempted               KernelHeaderFetchResult = 0
	KernelHeaderFetchResult_CustomHeadersFound              KernelHeaderFetchResult = 1
	KernelHeaderFetchResult_DefaultHeadersFound             KernelHeaderFetchResult = 2
	KernelHeaderFetchResult_SysfsHeadersFound               KernelHeaderFetchResult = 3
	KernelHeaderFetchResult_DownloadedHeadersFound          KernelHeaderFetchResult = 4
	KernelHeaderFetchResult_DownloadSuccess                 KernelHeaderFetchResult = 5
	KernelHeaderFetchResult_HostVersionErr                  KernelHeaderFetchResult = 6
	KernelHeaderFetchResult_DownloadFailure                 KernelHeaderFetchResult = 7
	KernelHeaderFetchResult_ValidationFailure               KernelHeaderFetchResult = 8
	KernelHeaderFetchResult_ReposDirAccessFailure           KernelHeaderFetchResult = 9
	KernelHeaderFetchResult_HeadersNotFoundDownloadDisabled KernelHeaderFetchResult = 10
)

var KernelHeaderFetchResult_name = map[int32]string{
	0:  "FetchNotAttempted",
	1:  "CustomHeadersFound",
	2:  "DefaultHeadersFound",
	3:  "SysfsHeadersFound",
	4:  "DownloadedHeadersFound",
	5:  "DownloadSuccess",
	6:  "HostVersionErr",
	7:  "DownloadFailure",
	8:  "ValidationFailure",
	9:  "ReposDirAccessFailure",
	10: "HeadersNotFoundDownloadDisabled",
}

var KernelHeaderFetchResult_value = map[string]int32{
	"FetchNotAttempted":               0,
	"CustomHeadersFound":              1,
	"DefaultHeadersFound":             2,
	"SysfsHeadersFound":               3,
	"DownloadedHeadersFound":          4,
	"DownloadSuccess":                 5,
	"HostVersionErr":                  6,
	"DownloadFailure":                 7,
	"ValidationFailure":               8,
	"ReposDirAccessFailure":           9,
	"HeadersNotFoundDownloadDisabled": 10,
}

func (x KernelHeaderFetchResult) String() string {
	return proto.EnumName(KernelHeaderFetchResult_name, int32(x))
}

func (KernelHeaderFetchResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{1}
}

type COREResult int32

const (
	COREResult_SuccessCustomBTF   COREResult = 0
	COREResult_SuccessEmbeddedBTF COREResult = 1
	COREResult_SuccessDefaultBTF  COREResult = 2
	COREResult_BtfNotFound        COREResult = 3
	COREResult_AssetReadError     COREResult = 4
	COREResult_VerifierError      COREResult = 5
	COREResult_LoaderError        COREResult = 6
)

var COREResult_name = map[int32]string{
	0: "SuccessCustomBTF",
	1: "SuccessEmbeddedBTF",
	2: "SuccessDefaultBTF",
	3: "BtfNotFound",
	4: "AssetReadError",
	5: "VerifierError",
	6: "LoaderError",
}

var COREResult_value = map[string]int32{
	"SuccessCustomBTF":   0,
	"SuccessEmbeddedBTF": 1,
	"SuccessDefaultBTF":  2,
	"BtfNotFound":        3,
	"AssetReadError":     4,
	"VerifierError":      5,
	"LoaderError":        6,
}

func (x COREResult) String() string {
	return proto.EnumName(COREResult_name, int32(x))
}

func (COREResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{2}
}

type ConnectionFamily int32

const (
	ConnectionFamily_v4 ConnectionFamily = 0
	ConnectionFamily_v6 ConnectionFamily = 1
)

var ConnectionFamily_name = map[int32]string{
	0: "v4",
	1: "v6",
}

var ConnectionFamily_value = map[string]int32{
	"v4": 0,
	"v6": 1,
}

func (x ConnectionFamily) String() string {
	return proto.EnumName(ConnectionFamily_name, int32(x))
}

func (ConnectionFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{3}
}

type ConnectionDirection int32

const (
	ConnectionDirection_unspecified ConnectionDirection = 0
	ConnectionDirection_incoming    ConnectionDirection = 1
	ConnectionDirection_outgoing    ConnectionDirection = 2
	ConnectionDirection_local       ConnectionDirection = 3
	ConnectionDirection_none        ConnectionDirection = 4
)

var ConnectionDirection_name = map[int32]string{
	0: "unspecified",
	1: "incoming",
	2: "outgoing",
	3: "local",
	4: "none",
}

var ConnectionDirection_value = map[string]int32{
	"unspecified": 0,
	"incoming":    1,
	"outgoing":    2,
	"local":       3,
	"none":        4,
}

func (x ConnectionDirection) String() string {
	return proto.EnumName(ConnectionDirection_name, int32(x))
}

func (ConnectionDirection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{4}
}

type EphemeralPortState int32

const (
	EphemeralPortState_ephemeralUnspecified EphemeralPortState = 0
	EphemeralPortState_ephemeralTrue        EphemeralPortState = 1
	EphemeralPortState_ephemeralFalse       EphemeralPortState = 2
)

var EphemeralPortState_name = map[int32]string{
	0: "ephemeralUnspecified",
	1: "ephemeralTrue",
	2: "ephemeralFalse",
}

var EphemeralPortState_value = map[string]int32{
	"ephemeralUnspecified": 0,
	"ephemeralTrue":        1,
	"ephemeralFalse":       2,
}

func (x EphemeralPortState) String() string {
	return proto.EnumName(EphemeralPortState_name, int32(x))
}

func (EphemeralPortState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{5}
}

type ProtocolType int32

const (
	ProtocolType_protocolUnclassified ProtocolType = 0
	ProtocolType_protocolUnknown      ProtocolType = 1
	ProtocolType_protocolHTTP         ProtocolType = 2
	ProtocolType_protocolHTTP2        ProtocolType = 3
	ProtocolType_protocolTLS          ProtocolType = 4
	ProtocolType_protocolKafka        ProtocolType = 5
	ProtocolType_protocolMongo        ProtocolType = 6
	ProtocolType_protocolPostgres     ProtocolType = 7
	ProtocolType_protocolAMQP         ProtocolType = 8
	ProtocolType_protocolRedis        ProtocolType = 9
	ProtocolType_protocolMySQL        ProtocolType = 10
	ProtocolType_protocolGRPC         ProtocolType = 11
)

var ProtocolType_name = map[int32]string{
	0:  "protocolUnclassified",
	1:  "protocolUnknown",
	2:  "protocolHTTP",
	3:  "protocolHTTP2",
	4:  "protocolTLS",
	5:  "protocolKafka",
	6:  "protocolMongo",
	7:  "protocolPostgres",
	8:  "protocolAMQP",
	9:  "protocolRedis",
	10: "protocolMySQL",
	11: "protocolGRPC",
}

var ProtocolType_value = map[string]int32{
	"protocolUnclassified": 0,
	"protocolUnknown":      1,
	"protocolHTTP":         2,
	"protocolHTTP2":        3,
	"protocolTLS":          4,
	"protocolKafka":        5,
	"protocolMongo":        6,
	"protocolPostgres":     7,
	"protocolAMQP":         8,
	"protocolRedis":        9,
	"protocolMySQL":        10,
	"protocolGRPC":         11,
}

func (x ProtocolType) String() string {
	return proto.EnumName(ProtocolType_name, int32(x))
}

func (ProtocolType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{6}
}

type CollectorConnections struct {
	// the detected hostname for the agent that collected these connections
	HostName string `protobuf:"bytes,2,opt,name=hostName,proto3" json:"hostName,omitempty"`
	// this "ID" of the network. This is generally set to VPC ID in the major clouds.
	NetworkId   string        `protobuf:"bytes,12,opt,name=networkId,proto3" json:"networkId,omitempty"`
	Connections []*Connection `protobuf:"bytes,3,rep,name=connections,proto3" json:"connections,omitempty"`
	// Message batching metadata
	GroupId   int32 `protobuf:"varint,5,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize int32 `protobuf:"varint,6,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	// Mapping of resourceID to metadata. For containers, each `connection` has a containerId field which can be mapped here.
	ResolvedResources map[string]*ResourceMetadata `protobuf:"bytes,8,rep,name=resolvedResources,proto3" json:"resolvedResources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Mapping of processes running in each container
	ContainerForPid map[int32]string `protobuf:"bytes,10,rep,name=containerForPid,proto3" json:"containerForPid,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// encodedTags is an opaque byte format that stores several sets of tags in a way that
	// is both Go GC friendly and handles duplicate tags well.
	//
	// Think of it as a write-once datastructure that maps a TagIndex (int)  -> []string. Types like ResourceMetadata
	// and Host reference 'tagIndexes' that can be used with an `encodedTags` to get a list of actual tags (in the form of a []string)
	//
	// this tag buffer can be written with `NewV2TagEncoder` and read with the helpers `CollectorConnections#GetTags` and `CollectorConnections#UnsafeIterateTags`.
	//
	// see process/tags_v2.go for a detailed explanation of the format.
	EncodedTags []byte `protobuf:"bytes,11,opt,name=encodedTags,proto3" json:"encodedTags,omitempty"`
	// This uses the same encoding structure as `encodedTags` but specifically encodes tags for connection-level tags
	// (e.g. Connection#TagIdx)
	EncodedConnectionsTags []byte            `protobuf:"bytes,38,opt,name=encodedConnectionsTags,proto3" json:"encodedConnectionsTags,omitempty"`
	ContainerHostType      ContainerHostType `protobuf:"varint,15,opt,name=containerHostType,proto3,enum=datadog.process_agent.ContainerHostType" json:"containerHostType,omitempty"`
	// For now, we'll keep emitting telemetry from agents < 7.35
	ConnTelemetry    *CollectorConnectionsTelemetry `protobuf:"bytes,16,opt,name=connTelemetry,proto3" json:"connTelemetry,omitempty"`
	ConnTelemetryMap map[string]int64               `protobuf:"bytes,39,rep,name=connTelemetryMap,proto3" json:"connTelemetryMap,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// OS Telemetry
	Architecture    string `protobuf:"bytes,17,opt,name=architecture,proto3" json:"architecture,omitempty"`
	KernelVersion   string `protobuf:"bytes,18,opt,name=kernelVersion,proto3" json:"kernelVersion,omitempty"`
	Platform        string `protobuf:"bytes,19,opt,name=platform,proto3" json:"platform,omitempty"`
	PlatformVersion string `protobuf:"bytes,20,opt,name=platformVersion,proto3" json:"platformVersion,omitempty"`
	// Runtime compilation telemetry
	CompilationTelemetryByAsset map[string]*RuntimeCompilationTelemetry `protobuf:"bytes,21,rep,name=compilationTelemetryByAsset,proto3" json:"compilationTelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	KernelHeaderFetchResult     KernelHeaderFetchResult                 `protobuf:"varint,41,opt,name=kernelHeaderFetchResult,proto3,enum=datadog.process_agent.KernelHeaderFetchResult" json:"kernelHeaderFetchResult,omitempty"`
	// CO-RE telemetry
	CORETelemetryByAsset map[string]COREResult `protobuf:"bytes,42,rep,name=CORETelemetryByAsset,proto3" json:"CORETelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=datadog.process_agent.COREResult"`
	// Prebuilt EBPF assets in use
	PrebuiltEBPFAssets []string `protobuf:"bytes,44,rep,name=PrebuiltEBPFAssets,proto3" json:"PrebuiltEBPFAssets,omitempty"`
	// the machine-local routes used for all connections in this payload. At the time of writing, this
	// captures the subnet of the interface used to send traffic out of machine. This is also AWS only at the time
	// of writing.
	// see Connection#routeIdx
	Routes []*Route `protobuf:"bytes,31,rep,name=routes,proto3" json:"routes,omitempty"`
	// the next l3 route for all connections in this payload, AWS only.
	RouteMetadata      []*RouteMetadata    `protobuf:"bytes,34,rep,name=routeMetadata,proto3" json:"routeMetadata,omitempty"`
	AgentConfiguration *AgentConfiguration `protobuf:"bytes,35,opt,name=agentConfiguration,proto3" json:"agentConfiguration,omitempty"`
	// encoded dns is a map of (string) ip-> list of domains (DNSEntry)
	EncodedDNS []byte `protobuf:"bytes,14,opt,name=encodedDNS,proto3" json:"encodedDNS,omitempty"`
	// All queried DNS domains for which we have collected stats
	Domains []string `protobuf:"bytes,30,rep,name=domains,proto3" json:"domains,omitempty"`
	//////////////////
	// V2 encodings
	// all domain strings are now indexes into a single array of strings
	// hostname query information.  Encoded via V2DNSEncoder.EncodeDomainDatabase
	// is a single buffer; varint number of strings, followed by each string.
	EncodedDomainDatabase []byte `protobuf:"bytes,36,opt,name=encodedDomainDatabase,proto3" json:"encodedDomainDatabase,omitempty"`
	// new representation of encoded DNS.  This is a map of the string representation
	// of the IP --> DNSDatabaseEntry message. (was encodedDNS).  Encoded
	// via V2DNSEncoder.EncodeMapped.  Full buffer description provided there.
	EncodedDnsLookups   []byte           `protobuf:"bytes,37,opt,name=encodedDnsLookups,proto3" json:"encodedDnsLookups,omitempty"`
	ResolvedHostsByName map[string]*Host `protobuf:"bytes,40,rep,name=resolvedHostsByName,proto3" json:"resolvedHostsByName,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	EcsTask             string           `protobuf:"bytes,45,opt,name=ecsTask,proto3" json:"ecsTask,omitempty"`
}

func (m *CollectorConnections) Reset()         { *m = CollectorConnections{} }
func (m *CollectorConnections) String() string { return proto.CompactTextString(m) }
func (*CollectorConnections) ProtoMessage()    {}
func (*CollectorConnections) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{0}
}
func (m *CollectorConnections) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorConnections) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorConnections.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorConnections) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorConnections.Merge(m, src)
}
func (m *CollectorConnections) XXX_Size() int {
	return m.Size()
}
func (m *CollectorConnections) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorConnections.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorConnections proto.InternalMessageInfo

func (m *CollectorConnections) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorConnections) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *CollectorConnections) GetConnections() []*Connection {
	if m != nil {
		return m.Connections
	}
	return nil
}

func (m *CollectorConnections) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorConnections) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorConnections) GetResolvedResources() map[string]*ResourceMetadata {
	if m != nil {
		return m.ResolvedResources
	}
	return nil
}

func (m *CollectorConnections) GetContainerForPid() map[int32]string {
	if m != nil {
		return m.ContainerForPid
	}
	return nil
}

func (m *CollectorConnections) GetEncodedTags() []byte {
	if m != nil {
		return m.EncodedTags
	}
	return nil
}

func (m *CollectorConnections) GetEncodedConnectionsTags() []byte {
	if m != nil {
		return m.EncodedConnectionsTags
	}
	return nil
}

func (m *CollectorConnections) GetContainerHostType() ContainerHostType {
	if m != nil {
		return m.ContainerHostType
	}
	return ContainerHostType_notSpecified
}

func (m *CollectorConnections) GetConnTelemetry() *CollectorConnectionsTelemetry {
	if m != nil {
		return m.ConnTelemetry
	}
	return nil
}

func (m *CollectorConnections) GetConnTelemetryMap() map[string]int64 {
	if m != nil {
		return m.ConnTelemetryMap
	}
	return nil
}

func (m *CollectorConnections) GetArchitecture() string {
	if m != nil {
		return m.Architecture
	}
	return ""
}

func (m *CollectorConnections) GetKernelVersion() string {
	if m != nil {
		return m.KernelVersion
	}
	return ""
}

func (m *CollectorConnections) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *CollectorConnections) GetPlatformVersion() string {
	if m != nil {
		return m.PlatformVersion
	}
	return ""
}

func (m *CollectorConnections) GetCompilationTelemetryByAsset() map[string]*RuntimeCompilationTelemetry {
	if m != nil {
		return m.CompilationTelemetryByAsset
	}
	return nil
}

func (m *CollectorConnections) GetKernelHeaderFetchResult() KernelHeaderFetchResult {
	if m != nil {
		return m.KernelHeaderFetchResult
	}
	return KernelHeaderFetchResult_FetchNotAttempted
}

func (m *CollectorConnections) GetCORETelemetryByAsset() map[string]COREResult {
	if m != nil {
		return m.CORETelemetryByAsset
	}
	return nil
}

func (m *CollectorConnections) GetPrebuiltEBPFAssets() []string {
	if m != nil {
		return m.PrebuiltEBPFAssets
	}
	return nil
}

func (m *CollectorConnections) GetRoutes() []*Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *CollectorConnections) GetRouteMetadata() []*RouteMetadata {
	if m != nil {
		return m.RouteMetadata
	}
	return nil
}

func (m *CollectorConnections) GetAgentConfiguration() *AgentConfiguration {
	if m != nil {
		return m.AgentConfiguration
	}
	return nil
}

func (m *CollectorConnections) GetEncodedDNS() []byte {
	if m != nil {
		return m.EncodedDNS
	}
	return nil
}

func (m *CollectorConnections) GetDomains() []string {
	if m != nil {
		return m.Domains
	}
	return nil
}

func (m *CollectorConnections) GetEncodedDomainDatabase() []byte {
	if m != nil {
		return m.EncodedDomainDatabase
	}
	return nil
}

func (m *CollectorConnections) GetEncodedDnsLookups() []byte {
	if m != nil {
		return m.EncodedDnsLookups
	}
	return nil
}

func (m *CollectorConnections) GetResolvedHostsByName() map[string]*Host {
	if m != nil {
		return m.ResolvedHostsByName
	}
	return nil
}

func (m *CollectorConnections) GetEcsTask() string {
	if m != nil {
		return m.EcsTask
	}
	return ""
}

// Connections is only used to communicate between the process agent and system-probe.
type Connections struct {
	Conns []*Connection        `protobuf:"bytes,1,rep,name=conns,proto3" json:"conns,omitempty"`
	Dns   map[string]*DNSEntry `protobuf:"bytes,2,rep,name=dns,proto3" json:"dns,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// For now, we'll keep emitting telemetry from agents < 7.35
	ConnTelemetry               *ConnectionsTelemetry                   `protobuf:"bytes,3,opt,name=connTelemetry,proto3" json:"connTelemetry,omitempty"`
	Domains                     []string                                `protobuf:"bytes,4,rep,name=domains,proto3" json:"domains,omitempty"`
	Routes                      []*Route                                `protobuf:"bytes,5,rep,name=routes,proto3" json:"routes,omitempty"`
	CompilationTelemetryByAsset map[string]*RuntimeCompilationTelemetry `protobuf:"bytes,6,rep,name=compilationTelemetryByAsset,proto3" json:"compilationTelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	AgentConfiguration          *AgentConfiguration                     `protobuf:"bytes,7,opt,name=agentConfiguration,proto3" json:"agentConfiguration,omitempty"`
	Tags                        []string                                `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	ConnTelemetryMap            map[string]int64                        `protobuf:"bytes,9,rep,name=connTelemetryMap,proto3" json:"connTelemetryMap,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	KernelHeaderFetchResult     KernelHeaderFetchResult                 `protobuf:"varint,10,opt,name=kernelHeaderFetchResult,proto3,enum=datadog.process_agent.KernelHeaderFetchResult" json:"kernelHeaderFetchResult,omitempty"`
	CORETelemetryByAsset        map[string]COREResult                   `protobuf:"bytes,11,rep,name=CORETelemetryByAsset,proto3" json:"CORETelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=datadog.process_agent.COREResult"`
	PrebuiltEBPFAssets          []string                                `protobuf:"bytes,12,rep,name=PrebuiltEBPFAssets,proto3" json:"PrebuiltEBPFAssets,omitempty"`
}

func (m *Connections) Reset()         { *m = Connections{} }
func (m *Connections) String() string { return proto.CompactTextString(m) }
func (*Connections) ProtoMessage()    {}
func (*Connections) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{1}
}
func (m *Connections) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connections) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connections.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connections) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connections.Merge(m, src)
}
func (m *Connections) XXX_Size() int {
	return m.Size()
}
func (m *Connections) XXX_DiscardUnknown() {
	xxx_messageInfo_Connections.DiscardUnknown(m)
}

var xxx_messageInfo_Connections proto.InternalMessageInfo

func (m *Connections) GetConns() []*Connection {
	if m != nil {
		return m.Conns
	}
	return nil
}

func (m *Connections) GetDns() map[string]*DNSEntry {
	if m != nil {
		return m.Dns
	}
	return nil
}

func (m *Connections) GetConnTelemetry() *ConnectionsTelemetry {
	if m != nil {
		return m.ConnTelemetry
	}
	return nil
}

func (m *Connections) GetDomains() []string {
	if m != nil {
		return m.Domains
	}
	return nil
}

func (m *Connections) GetRoutes() []*Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *Connections) GetCompilationTelemetryByAsset() map[string]*RuntimeCompilationTelemetry {
	if m != nil {
		return m.CompilationTelemetryByAsset
	}
	return nil
}

func (m *Connections) GetAgentConfiguration() *AgentConfiguration {
	if m != nil {
		return m.AgentConfiguration
	}
	return nil
}

func (m *Connections) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Connections) GetConnTelemetryMap() map[string]int64 {
	if m != nil {
		return m.ConnTelemetryMap
	}
	return nil
}

func (m *Connections) GetKernelHeaderFetchResult() KernelHeaderFetchResult {
	if m != nil {
		return m.KernelHeaderFetchResult
	}
	return KernelHeaderFetchResult_FetchNotAttempted
}

func (m *Connections) GetCORETelemetryByAsset() map[string]COREResult {
	if m != nil {
		return m.CORETelemetryByAsset
	}
	return nil
}

func (m *Connections) GetPrebuiltEBPFAssets() []string {
	if m != nil {
		return m.PrebuiltEBPFAssets
	}
	return nil
}

type Connection struct {
	Pid                  int32              `protobuf:"varint,1,opt,name=pid,proto3" json:"pid,omitempty"`
	Laddr                *Addr              `protobuf:"bytes,5,opt,name=laddr,proto3" json:"laddr,omitempty"`
	Raddr                *Addr              `protobuf:"bytes,6,opt,name=raddr,proto3" json:"raddr,omitempty"`
	Family               ConnectionFamily   `protobuf:"varint,10,opt,name=family,proto3,enum=datadog.process_agent.ConnectionFamily" json:"family,omitempty"`
	Type                 ConnectionType     `protobuf:"varint,11,opt,name=type,proto3,enum=datadog.process_agent.ConnectionType" json:"type,omitempty"`
	IsLocalPortEphemeral EphemeralPortState `protobuf:"varint,41,opt,name=isLocalPortEphemeral,proto3,enum=datadog.process_agent.EphemeralPortState" json:"isLocalPortEphemeral,omitempty"`
	// Relative counters since last check
	LastBytesSent       uint64              `protobuf:"varint,16,opt,name=lastBytesSent,proto3" json:"lastBytesSent,omitempty"`
	LastBytesReceived   uint64              `protobuf:"varint,17,opt,name=lastBytesReceived,proto3" json:"lastBytesReceived,omitempty"`
	LastRetransmits     uint32              `protobuf:"varint,18,opt,name=lastRetransmits,proto3" json:"lastRetransmits,omitempty"`
	Direction           ConnectionDirection `protobuf:"varint,19,opt,name=direction,proto3,enum=datadog.process_agent.ConnectionDirection" json:"direction,omitempty"`
	LastPacketsSent     uint64              `protobuf:"varint,38,opt,name=lastPacketsSent,proto3" json:"lastPacketsSent,omitempty"`
	LastPacketsReceived uint64              `protobuf:"varint,39,opt,name=lastPacketsReceived,proto3" json:"lastPacketsReceived,omitempty"`
	Protocol            *ProtocolStack      `protobuf:"bytes,48,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Network namespace
	NetNS uint32 `protobuf:"varint,20,opt,name=netNS,proto3" json:"netNS,omitempty"`
	// NetworkID of the remote address (post-resolution field)
	RemoteNetworkId string `protobuf:"bytes,32,opt,name=remoteNetworkId,proto3" json:"remoteNetworkId,omitempty"`
	// the conntrack entry associated with the connection. May be null on systems which don't support querying conntrack.
	IpTranslation *IPTranslation `protobuf:"bytes,21,opt,name=ipTranslation,proto3" json:"ipTranslation,omitempty"`
	// TCP-specific metrics
	Rtt    uint32 `protobuf:"varint,22,opt,name=rtt,proto3" json:"rtt,omitempty"`
	RttVar uint32 `protobuf:"varint,23,opt,name=rttVar,proto3" json:"rttVar,omitempty"`
	// Indicates that this connection begins and ends on the same host
	IntraHost bool `protobuf:"varint,24,opt,name=intraHost,proto3" json:"intraHost,omitempty"`
	// DNS-specific metrics
	DnsSuccessfulResponses uint32            `protobuf:"varint,25,opt,name=dnsSuccessfulResponses,proto3" json:"dnsSuccessfulResponses,omitempty"`
	DnsFailedResponses     uint32            `protobuf:"varint,26,opt,name=dnsFailedResponses,proto3" json:"dnsFailedResponses,omitempty"`
	DnsTimeouts            uint32            `protobuf:"varint,27,opt,name=dnsTimeouts,proto3" json:"dnsTimeouts,omitempty"`
	DnsSuccessLatencySum   uint64            `protobuf:"varint,28,opt,name=dnsSuccessLatencySum,proto3" json:"dnsSuccessLatencySum,omitempty"`
	DnsFailureLatencySum   uint64            `protobuf:"varint,29,opt,name=dnsFailureLatencySum,proto3" json:"dnsFailureLatencySum,omitempty"`
	DnsCountByRcode        map[uint32]uint32 `protobuf:"bytes,33,rep,name=dnsCountByRcode,proto3" json:"dnsCountByRcode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// TCP state transition counters relative to last check
	LastTcpEstablished uint32 `protobuf:"varint,30,opt,name=lastTcpEstablished,proto3" json:"lastTcpEstablished,omitempty"`
	LastTcpClosed      uint32 `protobuf:"varint,31,opt,name=lastTcpClosed,proto3" json:"lastTcpClosed,omitempty"`
	// dns stats based on domain queried, the key corresponds to an index into the `domains` field
	// dnsStatsByDomain is deprecated field, left in for handling old agent versions
	DnsStatsByDomain map[int32]*DNSStats `protobuf:"bytes,34,rep,name=dnsStatsByDomain,proto3" json:"dnsStatsByDomain,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// dnsStatsByDomainByQueryType is new field
	DnsStatsByDomainByQueryType map[int32]*DNSStatsByQueryType `protobuf:"bytes,42,rep,name=dnsStatsByDomainByQueryType,proto3" json:"dnsStatsByDomainByQueryType,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// int32 index into map is the offset into the CollectorConnections.encodedDomainDatabase
	DnsStatsByDomainOffsetByQueryType map[int32]*DNSStatsByQueryType `protobuf:"bytes,43,rep,name=dnsStatsByDomainOffsetByQueryType,proto3" json:"dnsStatsByDomainOffsetByQueryType,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// routeIdx is the index of the route used to exit the host that this connection was collected from. It is an index into
	// the CollectorConnections#routes field.
	RouteIdx int32 `protobuf:"varint,36,opt,name=routeIdx,proto3" json:"routeIdx,omitempty"`
	// the index of the resolved target of the route (post-resolution field)
	RouteTargetIdx int32 `protobuf:"varint,40,opt,name=routeTargetIdx,proto3" json:"routeTargetIdx,omitempty"`
	// serialized HTTPAggregations object summarizing all http transactions recorded for this connection, organized by request path
	HttpAggregations []byte `protobuf:"bytes,37,opt,name=httpAggregations,proto3" json:"httpAggregations,omitempty"`
	// The stored values corresponds to an index into the `Connections.tags` field
	Tags []uint32 `protobuf:"varint,44,rep,name=tags,proto3" json:"tags,omitempty"`
	// Pointer to tags for this connection, see CollectorConnections#encodedConnectionsTags.
	TagsIdx int32 `protobuf:"varint,45,opt,name=tagsIdx,proto3" json:"tagsIdx,omitempty"`
	// a checksum of all the tags in this connection. Populated by the agent, but used by the backend to know when tags have changed for a connection.
	TagsChecksum uint32 `protobuf:"varint,47,opt,name=tagsChecksum,proto3" json:"tagsChecksum,omitempty"`
	// Used for offset state management (backend)
	StateIndex uint32 `protobuf:"varint,46,opt,name=stateIndex,proto3" json:"stateIndex,omitempty"`
	// serialized DataStreamsAggregations object summarizing all data streams transactions (Kafka produce & Kafka fetch) recorded for this connection organized by topic
	DataStreamsAggregations []byte `protobuf:"bytes,49,opt,name=dataStreamsAggregations,proto3" json:"dataStreamsAggregations,omitempty"`
	// serialized HTTP2Aggregations object summarizing all http2 transactions recorded for this connection, organized by request path
	Http2Aggregations []byte `protobuf:"bytes,50,opt,name=http2Aggregations,proto3" json:"http2Aggregations,omitempty"`
	// serialized DatabaseAggregations object summarizing all database transactions recorded for this connection.
	DatabaseAggregations []byte `protobuf:"bytes,51,opt,name=databaseAggregations,proto3" json:"databaseAggregations,omitempty"`
	// serialized map of POSIX error codes to the number of times they have been encountered in the context of this connection (ex [110: 3] would mean that the connection has seen 3 ETIMEDOUT errors)
	TcpFailuresByErrCode map[uint32]uint32 `protobuf:"bytes,52,rep,name=tcpFailuresByErrCode,proto3" json:"tcpFailuresByErrCode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	RemoteEcsTask        string            `protobuf:"bytes,53,opt,name=remoteEcsTask,proto3" json:"remoteEcsTask,omitempty"`
}

func (m *Connection) Reset()         { *m = Connection{} }
func (m *Connection) String() string { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()    {}
func (*Connection) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{2}
}
func (m *Connection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection.Merge(m, src)
}
func (m *Connection) XXX_Size() int {
	return m.Size()
}
func (m *Connection) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection.DiscardUnknown(m)
}

var xxx_messageInfo_Connection proto.InternalMessageInfo

func (m *Connection) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *Connection) GetLaddr() *Addr {
	if m != nil {
		return m.Laddr
	}
	return nil
}

func (m *Connection) GetRaddr() *Addr {
	if m != nil {
		return m.Raddr
	}
	return nil
}

func (m *Connection) GetFamily() ConnectionFamily {
	if m != nil {
		return m.Family
	}
	return ConnectionFamily_v4
}

func (m *Connection) GetType() ConnectionType {
	if m != nil {
		return m.Type
	}
	return ConnectionType_tcp
}

func (m *Connection) GetIsLocalPortEphemeral() EphemeralPortState {
	if m != nil {
		return m.IsLocalPortEphemeral
	}
	return EphemeralPortState_ephemeralUnspecified
}

func (m *Connection) GetLastBytesSent() uint64 {
	if m != nil {
		return m.LastBytesSent
	}
	return 0
}

func (m *Connection) GetLastBytesReceived() uint64 {
	if m != nil {
		return m.LastBytesReceived
	}
	return 0
}

func (m *Connection) GetLastRetransmits() uint32 {
	if m != nil {
		return m.LastRetransmits
	}
	return 0
}

func (m *Connection) GetDirection() ConnectionDirection {
	if m != nil {
		return m.Direction
	}
	return ConnectionDirection_unspecified
}

func (m *Connection) GetLastPacketsSent() uint64 {
	if m != nil {
		return m.LastPacketsSent
	}
	return 0
}

func (m *Connection) GetLastPacketsReceived() uint64 {
	if m != nil {
		return m.LastPacketsReceived
	}
	return 0
}

func (m *Connection) GetProtocol() *ProtocolStack {
	if m != nil {
		return m.Protocol
	}
	return nil
}

func (m *Connection) GetNetNS() uint32 {
	if m != nil {
		return m.NetNS
	}
	return 0
}

func (m *Connection) GetRemoteNetworkId() string {
	if m != nil {
		return m.RemoteNetworkId
	}
	return ""
}

func (m *Connection) GetIpTranslation() *IPTranslation {
	if m != nil {
		return m.IpTranslation
	}
	return nil
}

func (m *Connection) GetRtt() uint32 {
	if m != nil {
		return m.Rtt
	}
	return 0
}

func (m *Connection) GetRttVar() uint32 {
	if m != nil {
		return m.RttVar
	}
	return 0
}

func (m *Connection) GetIntraHost() bool {
	if m != nil {
		return m.IntraHost
	}
	return false
}

func (m *Connection) GetDnsSuccessfulResponses() uint32 {
	if m != nil {
		return m.DnsSuccessfulResponses
	}
	return 0
}

func (m *Connection) GetDnsFailedResponses() uint32 {
	if m != nil {
		return m.DnsFailedResponses
	}
	return 0
}

func (m *Connection) GetDnsTimeouts() uint32 {
	if m != nil {
		return m.DnsTimeouts
	}
	return 0
}

func (m *Connection) GetDnsSuccessLatencySum() uint64 {
	if m != nil {
		return m.DnsSuccessLatencySum
	}
	return 0
}

func (m *Connection) GetDnsFailureLatencySum() uint64 {
	if m != nil {
		return m.DnsFailureLatencySum
	}
	return 0
}

func (m *Connection) GetDnsCountByRcode() map[uint32]uint32 {
	if m != nil {
		return m.DnsCountByRcode
	}
	return nil
}

func (m *Connection) GetLastTcpEstablished() uint32 {
	if m != nil {
		return m.LastTcpEstablished
	}
	return 0
}

func (m *Connection) GetLastTcpClosed() uint32 {
	if m != nil {
		return m.LastTcpClosed
	}
	return 0
}

func (m *Connection) GetDnsStatsByDomain() map[int32]*DNSStats {
	if m != nil {
		return m.DnsStatsByDomain
	}
	return nil
}

func (m *Connection) GetDnsStatsByDomainByQueryType() map[int32]*DNSStatsByQueryType {
	if m != nil {
		return m.DnsStatsByDomainByQueryType
	}
	return nil
}

func (m *Connection) GetDnsStatsByDomainOffsetByQueryType() map[int32]*DNSStatsByQueryType {
	if m != nil {
		return m.DnsStatsByDomainOffsetByQueryType
	}
	return nil
}

func (m *Connection) GetRouteIdx() int32 {
	if m != nil {
		return m.RouteIdx
	}
	return 0
}

func (m *Connection) GetRouteTargetIdx() int32 {
	if m != nil {
		return m.RouteTargetIdx
	}
	return 0
}

func (m *Connection) GetHttpAggregations() []byte {
	if m != nil {
		return m.HttpAggregations
	}
	return nil
}

func (m *Connection) GetTags() []uint32 {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Connection) GetTagsIdx() int32 {
	if m != nil {
		return m.TagsIdx
	}
	return 0
}

func (m *Connection) GetTagsChecksum() uint32 {
	if m != nil {
		return m.TagsChecksum
	}
	return 0
}

func (m *Connection) GetStateIndex() uint32 {
	if m != nil {
		return m.StateIndex
	}
	return 0
}

func (m *Connection) GetDataStreamsAggregations() []byte {
	if m != nil {
		return m.DataStreamsAggregations
	}
	return nil
}

func (m *Connection) GetHttp2Aggregations() []byte {
	if m != nil {
		return m.Http2Aggregations
	}
	return nil
}

func (m *Connection) GetDatabaseAggregations() []byte {
	if m != nil {
		return m.DatabaseAggregations
	}
	return nil
}

func (m *Connection) GetTcpFailuresByErrCode() map[uint32]uint32 {
	if m != nil {
		return m.TcpFailuresByErrCode
	}
	return nil
}

func (m *Connection) GetRemoteEcsTask() string {
	if m != nil {
		return m.RemoteEcsTask
	}
	return ""
}

// ResourceMetadata only holds enough information to identify a resource in connection data
type ResourceMetadata struct {
	Id      string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	ByteKey []byte `protobuf:"bytes,3,opt,name=byteKey,proto3" json:"byteKey,omitempty"`
	// backend use only, associates tags with a given ResourceMetadata.
	// when this type is serialized, always use tagIndex to point to an entry
	// in encodedTags.
	Tags []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// points to an index in CollectorConnections#encodedTags. Use the helpers defined in process/connections.go to access
	// the tags associated with this resource metadata.
	// `CollectorConnections#GetTags`, `CollectorConnections#UnsafeIterateTags',
	// `CollectorConnections#IterateResourceTags`, `CollectorConnections#GetResourceTags`
	TagIndex int32 `protobuf:"varint,5,opt,name=tagIndex,proto3" json:"tagIndex,omitempty"`
	// if set this is a unix timestamp of the last time the tags for a given resource changed.
	// if tags have been decoded for a given (byteKey, tagsModified) tuple, that set of tags will not change.
	TagsModified int64 `protobuf:"varint,6,opt,name=tagsModified,proto3" json:"tagsModified,omitempty"`
}

func (m *ResourceMetadata) Reset()         { *m = ResourceMetadata{} }
func (m *ResourceMetadata) String() string { return proto.CompactTextString(m) }
func (*ResourceMetadata) ProtoMessage()    {}
func (*ResourceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{3}
}
func (m *ResourceMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetadata.Merge(m, src)
}
func (m *ResourceMetadata) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetadata proto.InternalMessageInfo

func (m *ResourceMetadata) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ResourceMetadata) GetByteKey() []byte {
	if m != nil {
		return m.ByteKey
	}
	return nil
}

func (m *ResourceMetadata) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ResourceMetadata) GetTagIndex() int32 {
	if m != nil {
		return m.TagIndex
	}
	return 0
}

func (m *ResourceMetadata) GetTagsModified() int64 {
	if m != nil {
		return m.TagsModified
	}
	return 0
}

type ConnectionsTelemetry struct {
	MonotonicKprobesTriggered          int64 `protobuf:"varint,1,opt,name=monotonicKprobesTriggered,proto3" json:"monotonicKprobesTriggered,omitempty"`
	MonotonicKprobesMissed             int64 `protobuf:"varint,2,opt,name=monotonicKprobesMissed,proto3" json:"monotonicKprobesMissed,omitempty"`
	MonotonicConntrackRegisters        int64 `protobuf:"varint,3,opt,name=monotonicConntrackRegisters,proto3" json:"monotonicConntrackRegisters,omitempty"`
	MonotonicConntrackRegistersDropped int64 `protobuf:"varint,4,opt,name=monotonicConntrackRegistersDropped,proto3" json:"monotonicConntrackRegistersDropped,omitempty"`
	MonotonicDnsPacketsProcessed       int64 `protobuf:"varint,5,opt,name=monotonicDnsPacketsProcessed,proto3" json:"monotonicDnsPacketsProcessed,omitempty"`
	MonotonicConnsClosed               int64 `protobuf:"varint,6,opt,name=monotonicConnsClosed,proto3" json:"monotonicConnsClosed,omitempty"`
	ConnsBpfMapSize                    int64 `protobuf:"varint,7,opt,name=connsBpfMapSize,proto3" json:"connsBpfMapSize,omitempty"`
	MonotonicUdpSendsProcessed         int64 `protobuf:"varint,8,opt,name=monotonicUdpSendsProcessed,proto3" json:"monotonicUdpSendsProcessed,omitempty"`
	MonotonicUdpSendsMissed            int64 `protobuf:"varint,9,opt,name=monotonicUdpSendsMissed,proto3" json:"monotonicUdpSendsMissed,omitempty"`
	ConntrackSamplingPercent           int64 `protobuf:"varint,10,opt,name=conntrackSamplingPercent,proto3" json:"conntrackSamplingPercent,omitempty"`
	DnsStatsDropped                    int64 `protobuf:"varint,11,opt,name=dnsStatsDropped,proto3" json:"dnsStatsDropped,omitempty"`
}

func (m *ConnectionsTelemetry) Reset()         { *m = ConnectionsTelemetry{} }
func (m *ConnectionsTelemetry) String() string { return proto.CompactTextString(m) }
func (*ConnectionsTelemetry) ProtoMessage()    {}
func (*ConnectionsTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{4}
}
func (m *ConnectionsTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectionsTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectionsTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectionsTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionsTelemetry.Merge(m, src)
}
func (m *ConnectionsTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *ConnectionsTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionsTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionsTelemetry proto.InternalMessageInfo

func (m *ConnectionsTelemetry) GetMonotonicKprobesTriggered() int64 {
	if m != nil {
		return m.MonotonicKprobesTriggered
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicKprobesMissed() int64 {
	if m != nil {
		return m.MonotonicKprobesMissed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicConntrackRegisters() int64 {
	if m != nil {
		return m.MonotonicConntrackRegisters
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicConntrackRegistersDropped() int64 {
	if m != nil {
		return m.MonotonicConntrackRegistersDropped
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicDnsPacketsProcessed() int64 {
	if m != nil {
		return m.MonotonicDnsPacketsProcessed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicConnsClosed() int64 {
	if m != nil {
		return m.MonotonicConnsClosed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetConnsBpfMapSize() int64 {
	if m != nil {
		return m.ConnsBpfMapSize
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicUdpSendsProcessed() int64 {
	if m != nil {
		return m.MonotonicUdpSendsProcessed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicUdpSendsMissed() int64 {
	if m != nil {
		return m.MonotonicUdpSendsMissed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetConntrackSamplingPercent() int64 {
	if m != nil {
		return m.ConntrackSamplingPercent
	}
	return 0
}

func (m *ConnectionsTelemetry) GetDnsStatsDropped() int64 {
	if m != nil {
		return m.DnsStatsDropped
	}
	return 0
}

type CollectorConnectionsTelemetry struct {
	KprobesTriggered          int64 `protobuf:"varint,1,opt,name=kprobesTriggered,proto3" json:"kprobesTriggered,omitempty"`
	KprobesMissed             int64 `protobuf:"varint,2,opt,name=kprobesMissed,proto3" json:"kprobesMissed,omitempty"`
	ConntrackRegisters        int64 `protobuf:"varint,3,opt,name=conntrackRegisters,proto3" json:"conntrackRegisters,omitempty"`
	ConntrackRegistersDropped int64 `protobuf:"varint,4,opt,name=conntrackRegistersDropped,proto3" json:"conntrackRegistersDropped,omitempty"`
	DnsPacketsProcessed       int64 `protobuf:"varint,5,opt,name=dnsPacketsProcessed,proto3" json:"dnsPacketsProcessed,omitempty"`
	ConnsClosed               int64 `protobuf:"varint,6,opt,name=connsClosed,proto3" json:"connsClosed,omitempty"`
	ConnsBpfMapSize           int64 `protobuf:"varint,7,opt,name=connsBpfMapSize,proto3" json:"connsBpfMapSize,omitempty"`
	UdpSendsProcessed         int64 `protobuf:"varint,8,opt,name=udpSendsProcessed,proto3" json:"udpSendsProcessed,omitempty"`
	UdpSendsMissed            int64 `protobuf:"varint,9,opt,name=udpSendsMissed,proto3" json:"udpSendsMissed,omitempty"`
	ConntrackSamplingPercent  int64 `protobuf:"varint,10,opt,name=conntrackSamplingPercent,proto3" json:"conntrackSamplingPercent,omitempty"`
	DnsStatsDropped           int64 `protobuf:"varint,11,opt,name=dnsStatsDropped,proto3" json:"dnsStatsDropped,omitempty"`
}

func (m *CollectorConnectionsTelemetry) Reset()         { *m = CollectorConnectionsTelemetry{} }
func (m *CollectorConnectionsTelemetry) String() string { return proto.CompactTextString(m) }
func (*CollectorConnectionsTelemetry) ProtoMessage()    {}
func (*CollectorConnectionsTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{5}
}
func (m *CollectorConnectionsTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorConnectionsTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorConnectionsTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorConnectionsTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorConnectionsTelemetry.Merge(m, src)
}
func (m *CollectorConnectionsTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *CollectorConnectionsTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorConnectionsTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorConnectionsTelemetry proto.InternalMessageInfo

func (m *CollectorConnectionsTelemetry) GetKprobesTriggered() int64 {
	if m != nil {
		return m.KprobesTriggered
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetKprobesMissed() int64 {
	if m != nil {
		return m.KprobesMissed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConntrackRegisters() int64 {
	if m != nil {
		return m.ConntrackRegisters
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConntrackRegistersDropped() int64 {
	if m != nil {
		return m.ConntrackRegistersDropped
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetDnsPacketsProcessed() int64 {
	if m != nil {
		return m.DnsPacketsProcessed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConnsClosed() int64 {
	if m != nil {
		return m.ConnsClosed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConnsBpfMapSize() int64 {
	if m != nil {
		return m.ConnsBpfMapSize
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetUdpSendsProcessed() int64 {
	if m != nil {
		return m.UdpSendsProcessed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetUdpSendsMissed() int64 {
	if m != nil {
		return m.UdpSendsMissed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConntrackSamplingPercent() int64 {
	if m != nil {
		return m.ConntrackSamplingPercent
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetDnsStatsDropped() int64 {
	if m != nil {
		return m.DnsStatsDropped
	}
	return 0
}

type RuntimeCompilationTelemetry struct {
	RuntimeCompilationEnabled  bool                     `protobuf:"varint,1,opt,name=runtimeCompilationEnabled,proto3" json:"runtimeCompilationEnabled,omitempty"`
	RuntimeCompilationResult   RuntimeCompilationResult `protobuf:"varint,2,opt,name=runtimeCompilationResult,proto3,enum=datadog.process_agent.RuntimeCompilationResult" json:"runtimeCompilationResult,omitempty"`
	RuntimeCompilationDuration int64                    `protobuf:"varint,3,opt,name=runtimeCompilationDuration,proto3" json:"runtimeCompilationDuration,omitempty"`
	// Field below was deprecated in agent 7.41
	KernelHeaderFetchResult KernelHeaderFetchResult `protobuf:"varint,4,opt,name=kernelHeaderFetchResult,proto3,enum=datadog.process_agent.KernelHeaderFetchResult" json:"kernelHeaderFetchResult,omitempty"`
}

func (m *RuntimeCompilationTelemetry) Reset()         { *m = RuntimeCompilationTelemetry{} }
func (m *RuntimeCompilationTelemetry) String() string { return proto.CompactTextString(m) }
func (*RuntimeCompilationTelemetry) ProtoMessage()    {}
func (*RuntimeCompilationTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{6}
}
func (m *RuntimeCompilationTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeCompilationTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeCompilationTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeCompilationTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeCompilationTelemetry.Merge(m, src)
}
func (m *RuntimeCompilationTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeCompilationTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeCompilationTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeCompilationTelemetry proto.InternalMessageInfo

func (m *RuntimeCompilationTelemetry) GetRuntimeCompilationEnabled() bool {
	if m != nil {
		return m.RuntimeCompilationEnabled
	}
	return false
}

func (m *RuntimeCompilationTelemetry) GetRuntimeCompilationResult() RuntimeCompilationResult {
	if m != nil {
		return m.RuntimeCompilationResult
	}
	return RuntimeCompilationResult_NotAttempted
}

func (m *RuntimeCompilationTelemetry) GetRuntimeCompilationDuration() int64 {
	if m != nil {
		return m.RuntimeCompilationDuration
	}
	return 0
}

func (m *RuntimeCompilationTelemetry) GetKernelHeaderFetchResult() KernelHeaderFetchResult {
	if m != nil {
		return m.KernelHeaderFetchResult
	}
	return KernelHeaderFetchResult_FetchNotAttempted
}

type AgentConfiguration struct {
	NpmEnabled bool `protobuf:"varint,1,opt,name=npmEnabled,proto3" json:"npmEnabled,omitempty"`
	UsmEnabled bool `protobuf:"varint,2,opt,name=usmEnabled,proto3" json:"usmEnabled,omitempty"`
	DsmEnabled bool `protobuf:"varint,3,opt,name=dsmEnabled,proto3" json:"dsmEnabled,omitempty"`
	CcmEnabled bool `protobuf:"varint,4,opt,name=ccmEnabled,proto3" json:"ccmEnabled,omitempty"`
	CsmEnabled bool `protobuf:"varint,5,opt,name=csmEnabled,proto3" json:"csmEnabled,omitempty"`
}

func (m *AgentConfiguration) Reset()         { *m = AgentConfiguration{} }
func (m *AgentConfiguration) String() string { return proto.CompactTextString(m) }
func (*AgentConfiguration) ProtoMessage()    {}
func (*AgentConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{7}
}
func (m *AgentConfiguration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AgentConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AgentConfiguration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AgentConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgentConfiguration.Merge(m, src)
}
func (m *AgentConfiguration) XXX_Size() int {
	return m.Size()
}
func (m *AgentConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_AgentConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_AgentConfiguration proto.InternalMessageInfo

func (m *AgentConfiguration) GetNpmEnabled() bool {
	if m != nil {
		return m.NpmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetUsmEnabled() bool {
	if m != nil {
		return m.UsmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetDsmEnabled() bool {
	if m != nil {
		return m.DsmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetCcmEnabled() bool {
	if m != nil {
		return m.CcmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetCsmEnabled() bool {
	if m != nil {
		return m.CsmEnabled
	}
	return false
}

// Route refers to a route out of a host (think `ip route get`).
// this is used primarily in AWS where we discover the subnet a
// that a connection was associated with
type Route struct {
	Subnet *Subnet `protobuf:"bytes,1,opt,name=subnet,proto3" json:"subnet,omitempty"`
}

func (m *Route) Reset()         { *m = Route{} }
func (m *Route) String() string { return proto.CompactTextString(m) }
func (*Route) ProtoMessage()    {}
func (*Route) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{8}
}
func (m *Route) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Route) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Route.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Route) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Route.Merge(m, src)
}
func (m *Route) XXX_Size() int {
	return m.Size()
}
func (m *Route) XXX_DiscardUnknown() {
	xxx_messageInfo_Route.DiscardUnknown(m)
}

var xxx_messageInfo_Route proto.InternalMessageInfo

func (m *Route) GetSubnet() *Subnet {
	if m != nil {
		return m.Subnet
	}
	return nil
}

type Subnet struct {
	Alias string `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
}

func (m *Subnet) Reset()         { *m = Subnet{} }
func (m *Subnet) String() string { return proto.CompactTextString(m) }
func (*Subnet) ProtoMessage()    {}
func (*Subnet) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{9}
}
func (m *Subnet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subnet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Subnet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Subnet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subnet.Merge(m, src)
}
func (m *Subnet) XXX_Size() int {
	return m.Size()
}
func (m *Subnet) XXX_DiscardUnknown() {
	xxx_messageInfo_Subnet.DiscardUnknown(m)
}

var xxx_messageInfo_Subnet proto.InternalMessageInfo

func (m *Subnet) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

// RouteMetadata
type RouteMetadata struct {
	Alias string `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
	// the tags for the inferred route target (see Connection#routeTargetIdx)
	// whenever this type is encoded on the wire, use tagsIndex and tagsModified -- not tags.
	TagIndex     int32    `protobuf:"varint,2,opt,name=tagIndex,proto3" json:"tagIndex,omitempty"`
	TagsModified int64    `protobuf:"varint,3,opt,name=tagsModified,proto3" json:"tagsModified,omitempty"`
	Tags         []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *RouteMetadata) Reset()         { *m = RouteMetadata{} }
func (m *RouteMetadata) String() string { return proto.CompactTextString(m) }
func (*RouteMetadata) ProtoMessage()    {}
func (*RouteMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{10}
}
func (m *RouteMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RouteMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RouteMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteMetadata.Merge(m, src)
}
func (m *RouteMetadata) XXX_Size() int {
	return m.Size()
}
func (m *RouteMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RouteMetadata proto.InternalMessageInfo

func (m *RouteMetadata) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *RouteMetadata) GetTagIndex() int32 {
	if m != nil {
		return m.TagIndex
	}
	return 0
}

func (m *RouteMetadata) GetTagsModified() int64 {
	if m != nil {
		return m.TagsModified
	}
	return 0
}

func (m *RouteMetadata) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type IPTranslation struct {
	ReplSrcIP   string `protobuf:"bytes,1,opt,name=replSrcIP,proto3" json:"replSrcIP,omitempty"`
	ReplDstIP   string `protobuf:"bytes,2,opt,name=replDstIP,proto3" json:"replDstIP,omitempty"`
	ReplSrcPort int32  `protobuf:"varint,3,opt,name=replSrcPort,proto3" json:"replSrcPort,omitempty"`
	ReplDstPort int32  `protobuf:"varint,4,opt,name=replDstPort,proto3" json:"replDstPort,omitempty"`
}

func (m *IPTranslation) Reset()         { *m = IPTranslation{} }
func (m *IPTranslation) String() string { return proto.CompactTextString(m) }
func (*IPTranslation) ProtoMessage()    {}
func (*IPTranslation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{11}
}
func (m *IPTranslation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPTranslation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPTranslation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPTranslation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPTranslation.Merge(m, src)
}
func (m *IPTranslation) XXX_Size() int {
	return m.Size()
}
func (m *IPTranslation) XXX_DiscardUnknown() {
	xxx_messageInfo_IPTranslation.DiscardUnknown(m)
}

var xxx_messageInfo_IPTranslation proto.InternalMessageInfo

func (m *IPTranslation) GetReplSrcIP() string {
	if m != nil {
		return m.ReplSrcIP
	}
	return ""
}

func (m *IPTranslation) GetReplDstIP() string {
	if m != nil {
		return m.ReplDstIP
	}
	return ""
}

func (m *IPTranslation) GetReplSrcPort() int32 {
	if m != nil {
		return m.ReplSrcPort
	}
	return 0
}

func (m *IPTranslation) GetReplDstPort() int32 {
	if m != nil {
		return m.ReplDstPort
	}
	return 0
}

type Addr struct {
	Ip   string `protobuf:"bytes,2,opt,name=ip,proto3" json:"ip,omitempty"`
	Port int32  `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// the containerID associated with the addr. This value can be used to look up a value in
	// CollectorConnections#resolvedResources.
	//
	// Despite the name, this can be either a containerID or a cloud loadbalancer.
	//
	// this will usually be added during resolution, but if the container is on the same host
	// where the connection was collected this will be set by the agent
	ContainerId string `protobuf:"bytes,5,opt,name=containerId,proto3" json:"containerId,omitempty"`
	// the host associated with the addr. This value can be used to look up a value in
	// CollectorConnections#resolvedHostsByName.
	HostName string `protobuf:"bytes,7,opt,name=hostName,proto3" json:"hostName,omitempty"`
}

func (m *Addr) Reset()         { *m = Addr{} }
func (m *Addr) String() string { return proto.CompactTextString(m) }
func (*Addr) ProtoMessage()    {}
func (*Addr) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{12}
}
func (m *Addr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Addr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Addr.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Addr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Addr.Merge(m, src)
}
func (m *Addr) XXX_Size() int {
	return m.Size()
}
func (m *Addr) XXX_DiscardUnknown() {
	xxx_messageInfo_Addr.DiscardUnknown(m)
}

var xxx_messageInfo_Addr proto.InternalMessageInfo

func (m *Addr) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *Addr) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Addr) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *Addr) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

type ProtocolStack struct {
	Stack []ProtocolType `protobuf:"varint,1,rep,name=stack,proto3,enum=datadog.process_agent.ProtocolType" json:"stack,omitempty"`
}

func (m *ProtocolStack) Reset()         { *m = ProtocolStack{} }
func (m *ProtocolStack) String() string { return proto.CompactTextString(m) }
func (*ProtocolStack) ProtoMessage()    {}
func (*ProtocolStack) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{13}
}
func (m *ProtocolStack) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProtocolStack) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProtocolStack.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProtocolStack) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProtocolStack.Merge(m, src)
}
func (m *ProtocolStack) XXX_Size() int {
	return m.Size()
}
func (m *ProtocolStack) XXX_DiscardUnknown() {
	xxx_messageInfo_ProtocolStack.DiscardUnknown(m)
}

var xxx_messageInfo_ProtocolStack proto.InternalMessageInfo

func (m *ProtocolStack) GetStack() []ProtocolType {
	if m != nil {
		return m.Stack
	}
	return nil
}

type DNSEntry struct {
	Names []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (m *DNSEntry) Reset()         { *m = DNSEntry{} }
func (m *DNSEntry) String() string { return proto.CompactTextString(m) }
func (*DNSEntry) ProtoMessage()    {}
func (*DNSEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{14}
}
func (m *DNSEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSEntry.Merge(m, src)
}
func (m *DNSEntry) XXX_Size() int {
	return m.Size()
}
func (m *DNSEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSEntry.DiscardUnknown(m)
}

var xxx_messageInfo_DNSEntry proto.InternalMessageInfo

func (m *DNSEntry) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

type DNSStats struct {
	DnsTimeouts          uint32            `protobuf:"varint,1,opt,name=dnsTimeouts,proto3" json:"dnsTimeouts,omitempty"`
	DnsSuccessLatencySum uint64            `protobuf:"varint,2,opt,name=dnsSuccessLatencySum,proto3" json:"dnsSuccessLatencySum,omitempty"`
	DnsFailureLatencySum uint64            `protobuf:"varint,3,opt,name=dnsFailureLatencySum,proto3" json:"dnsFailureLatencySum,omitempty"`
	DnsCountByRcode      map[uint32]uint32 `protobuf:"bytes,4,rep,name=dnsCountByRcode,proto3" json:"dnsCountByRcode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *DNSStats) Reset()         { *m = DNSStats{} }
func (m *DNSStats) String() string { return proto.CompactTextString(m) }
func (*DNSStats) ProtoMessage()    {}
func (*DNSStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{15}
}
func (m *DNSStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSStats.Merge(m, src)
}
func (m *DNSStats) XXX_Size() int {
	return m.Size()
}
func (m *DNSStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSStats.DiscardUnknown(m)
}

var xxx_messageInfo_DNSStats proto.InternalMessageInfo

func (m *DNSStats) GetDnsTimeouts() uint32 {
	if m != nil {
		return m.DnsTimeouts
	}
	return 0
}

func (m *DNSStats) GetDnsSuccessLatencySum() uint64 {
	if m != nil {
		return m.DnsSuccessLatencySum
	}
	return 0
}

func (m *DNSStats) GetDnsFailureLatencySum() uint64 {
	if m != nil {
		return m.DnsFailureLatencySum
	}
	return 0
}

func (m *DNSStats) GetDnsCountByRcode() map[uint32]uint32 {
	if m != nil {
		return m.DnsCountByRcode
	}
	return nil
}

type DNSStatsByQueryType struct {
	DnsStatsByQueryType map[int32]*DNSStats `protobuf:"bytes,1,rep,name=dnsStatsByQueryType,proto3" json:"dnsStatsByQueryType,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *DNSStatsByQueryType) Reset()         { *m = DNSStatsByQueryType{} }
func (m *DNSStatsByQueryType) String() string { return proto.CompactTextString(m) }
func (*DNSStatsByQueryType) ProtoMessage()    {}
func (*DNSStatsByQueryType) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{16}
}
func (m *DNSStatsByQueryType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSStatsByQueryType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSStatsByQueryType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSStatsByQueryType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSStatsByQueryType.Merge(m, src)
}
func (m *DNSStatsByQueryType) XXX_Size() int {
	return m.Size()
}
func (m *DNSStatsByQueryType) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSStatsByQueryType.DiscardUnknown(m)
}

var xxx_messageInfo_DNSStatsByQueryType proto.InternalMessageInfo

func (m *DNSStatsByQueryType) GetDnsStatsByQueryType() map[int32]*DNSStats {
	if m != nil {
		return m.DnsStatsByQueryType
	}
	return nil
}

func init() {
	proto.RegisterEnum("datadog.process_agent.RuntimeCompilationResult", RuntimeCompilationResult_name, RuntimeCompilationResult_value)
	proto.RegisterEnum("datadog.process_agent.KernelHeaderFetchResult", KernelHeaderFetchResult_name, KernelHeaderFetchResult_value)
	proto.RegisterEnum("datadog.process_agent.COREResult", COREResult_name, COREResult_value)
	proto.RegisterEnum("datadog.process_agent.ConnectionFamily", ConnectionFamily_name, ConnectionFamily_value)
	proto.RegisterEnum("datadog.process_agent.ConnectionDirection", ConnectionDirection_name, ConnectionDirection_value)
	proto.RegisterEnum("datadog.process_agent.EphemeralPortState", EphemeralPortState_name, EphemeralPortState_value)
	proto.RegisterEnum("datadog.process_agent.ProtocolType", ProtocolType_name, ProtocolType_value)
	proto.RegisterType((*CollectorConnections)(nil), "datadog.process_agent.CollectorConnections")
	proto.RegisterMapType((map[string]COREResult)(nil), "datadog.process_agent.CollectorConnections.CORETelemetryByAssetEntry")
	proto.RegisterMapType((map[string]*RuntimeCompilationTelemetry)(nil), "datadog.process_agent.CollectorConnections.CompilationTelemetryByAssetEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.CollectorConnections.ConnTelemetryMapEntry")
	proto.RegisterMapType((map[int32]string)(nil), "datadog.process_agent.CollectorConnections.ContainerForPidEntry")
	proto.RegisterMapType((map[string]*Host)(nil), "datadog.process_agent.CollectorConnections.ResolvedHostsByNameEntry")
	proto.RegisterMapType((map[string]*ResourceMetadata)(nil), "datadog.process_agent.CollectorConnections.ResolvedResourcesEntry")
	proto.RegisterType((*Connections)(nil), "datadog.process_agent.Connections")
	proto.RegisterMapType((map[string]COREResult)(nil), "datadog.process_agent.Connections.CORETelemetryByAssetEntry")
	proto.RegisterMapType((map[string]*RuntimeCompilationTelemetry)(nil), "datadog.process_agent.Connections.CompilationTelemetryByAssetEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.Connections.ConnTelemetryMapEntry")
	proto.RegisterMapType((map[string]*DNSEntry)(nil), "datadog.process_agent.Connections.DnsEntry")
	proto.RegisterType((*Connection)(nil), "datadog.process_agent.Connection")
	proto.RegisterMapType((map[uint32]uint32)(nil), "datadog.process_agent.Connection.DnsCountByRcodeEntry")
	proto.RegisterMapType((map[int32]*DNSStatsByQueryType)(nil), "datadog.process_agent.Connection.DnsStatsByDomainByQueryTypeEntry")
	proto.RegisterMapType((map[int32]*DNSStats)(nil), "datadog.process_agent.Connection.DnsStatsByDomainEntry")
	proto.RegisterMapType((map[int32]*DNSStatsByQueryType)(nil), "datadog.process_agent.Connection.DnsStatsByDomainOffsetByQueryTypeEntry")
	proto.RegisterMapType((map[uint32]uint32)(nil), "datadog.process_agent.Connection.TcpFailuresByErrCodeEntry")
	proto.RegisterType((*ResourceMetadata)(nil), "datadog.process_agent.ResourceMetadata")
	proto.RegisterType((*ConnectionsTelemetry)(nil), "datadog.process_agent.ConnectionsTelemetry")
	proto.RegisterType((*CollectorConnectionsTelemetry)(nil), "datadog.process_agent.CollectorConnectionsTelemetry")
	proto.RegisterType((*RuntimeCompilationTelemetry)(nil), "datadog.process_agent.RuntimeCompilationTelemetry")
	proto.RegisterType((*AgentConfiguration)(nil), "datadog.process_agent.AgentConfiguration")
	proto.RegisterType((*Route)(nil), "datadog.process_agent.Route")
	proto.RegisterType((*Subnet)(nil), "datadog.process_agent.Subnet")
	proto.RegisterType((*RouteMetadata)(nil), "datadog.process_agent.RouteMetadata")
	proto.RegisterType((*IPTranslation)(nil), "datadog.process_agent.IPTranslation")
	proto.RegisterType((*Addr)(nil), "datadog.process_agent.Addr")
	proto.RegisterType((*ProtocolStack)(nil), "datadog.process_agent.ProtocolStack")
	proto.RegisterType((*DNSEntry)(nil), "datadog.process_agent.DNSEntry")
	proto.RegisterType((*DNSStats)(nil), "datadog.process_agent.DNSStats")
	proto.RegisterMapType((map[uint32]uint32)(nil), "datadog.process_agent.DNSStats.DnsCountByRcodeEntry")
	proto.RegisterType((*DNSStatsByQueryType)(nil), "datadog.process_agent.DNSStatsByQueryType")
	proto.RegisterMapType((map[int32]*DNSStats)(nil), "datadog.process_agent.DNSStatsByQueryType.DnsStatsByQueryTypeEntry")
}

func init() { proto.RegisterFile("proto/process/connections.proto", fileDescriptor_8f660660e88b5927) }

var fileDescriptor_8f660660e88b5927 = []byte{
	// 3271 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcd, 0x73, 0xdb, 0xc6,
	0xd9, 0x37, 0xf8, 0x21, 0x91, 0x0f, 0xf5, 0x01, 0xad, 0x3e, 0x0c, 0xcb, 0x8e, 0x4c, 0xd3, 0x8e,
	0xad, 0x28, 0x8e, 0x9c, 0x28, 0xb6, 0x93, 0x37, 0x6f, 0x92, 0xd7, 0xa2, 0x28, 0x45, 0x92, 0x6d,
	0x99, 0x06, 0x69, 0x67, 0xde, 0xcc, 0xbc, 0x1f, 0x10, 0xb0, 0xa2, 0x10, 0x81, 0x00, 0x66, 0x77,
	0x61, 0x87, 0x39, 0x75, 0x3a, 0xed, 0xb5, 0xed, 0x74, 0xa6, 0x99, 0x69, 0x4f, 0xb9, 0xf6, 0xde,
	0x43, 0xff, 0x84, 0x1e, 0x73, 0xec, 0xb1, 0x13, 0xff, 0x07, 0x9d, 0xe9, 0xa1, 0xb7, 0xce, 0xee,
	0x02, 0x24, 0x40, 0x02, 0xa2, 0x94, 0xba, 0x99, 0x9e, 0x08, 0xfc, 0x9e, 0xaf, 0xdd, 0x07, 0xcf,
	0xee, 0xf3, 0xec, 0xb3, 0x84, 0xab, 0x3e, 0xf1, 0x98, 0x77, 0xc7, 0x27, 0x9e, 0x89, 0x29, 0xbd,
	0x63, 0x7a, 0xae, 0x8b, 0x4d, 0x66, 0x7b, 0x2e, 0x5d, 0x17, 0x14, 0xb4, 0x68, 0x19, 0xcc, 0xb0,
	0xbc, 0xce, 0x7a, 0xc8, 0xf2, 0x7f, 0x46, 0x07, 0xbb, 0x6c, 0xf9, 0x52, 0x52, 0x4e, 0x80, 0x52,
	0xa2, 0xf6, 0x6a, 0x1e, 0x16, 0xb6, 0x3c, 0xc7, 0xc1, 0x26, 0xf3, 0xc8, 0xd6, 0x40, 0x21, 0x5a,
	0x86, 0xd2, 0xb1, 0x47, 0xd9, 0x81, 0xd1, 0xc5, 0x5a, 0xae, 0xaa, 0xac, 0x96, 0xf5, 0xfe, 0x3b,
	0xba, 0x02, 0x65, 0x17, 0xb3, 0x97, 0x1e, 0x39, 0xd9, 0xb3, 0xb4, 0x29, 0x41, 0x1c, 0x00, 0x68,
	0x0b, 0x2a, 0xb1, 0x91, 0x69, 0xf9, 0x6a, 0x7e, 0xb5, 0xb2, 0x71, 0x6d, 0x3d, 0x75, 0x68, 0xeb,
	0x03, 0x93, 0x7a, 0x5c, 0x0a, 0x69, 0x30, 0xd9, 0x21, 0x5e, 0xe0, 0xef, 0x59, 0x5a, 0xb1, 0xaa,
	0xac, 0x16, 0xf5, 0xe8, 0x95, 0x1b, 0x17, 0x8f, 0x2d, 0xfb, 0x6b, 0xac, 0x4d, 0x08, 0xda, 0x00,
	0x40, 0x3e, 0xcc, 0x11, 0x4c, 0x3d, 0xe7, 0x05, 0xb6, 0x74, 0x4c, 0xbd, 0x80, 0x98, 0x98, 0x6a,
	0x25, 0x31, 0x84, 0x7a, 0xe6, 0x10, 0x46, 0xa7, 0xbf, 0xae, 0x0f, 0x2b, 0xd9, 0x76, 0x19, 0xe9,
	0xe9, 0xa3, 0xca, 0xd1, 0x97, 0x30, 0x6b, 0x7a, 0x2e, 0x33, 0x6c, 0x17, 0x93, 0x1d, 0x8f, 0x34,
	0x6d, 0x4b, 0x03, 0x61, 0xef, 0xc1, 0x79, 0xec, 0x6d, 0x25, 0x55, 0x48, 0x6b, 0xc3, 0x8a, 0x51,
	0x15, 0x2a, 0xd8, 0x35, 0x3d, 0x0b, 0x5b, 0x6d, 0xa3, 0x43, 0xb5, 0x4a, 0x55, 0x59, 0x9d, 0xd2,
	0xe3, 0x10, 0xba, 0x0f, 0x4b, 0xe1, 0x6b, 0x4c, 0xbb, 0x60, 0xbe, 0x29, 0x98, 0x33, 0xa8, 0xe8,
	0x39, 0xcc, 0xf5, 0x8d, 0xed, 0x7a, 0x94, 0xb5, 0x7b, 0x3e, 0xd6, 0x66, 0xab, 0xca, 0xea, 0xcc,
	0xc6, 0x6a, 0xf6, 0xa7, 0x4b, 0xf2, 0xeb, 0xa3, 0x2a, 0xd0, 0x17, 0x30, 0xcd, 0x3f, 0x6b, 0x1b,
	0x3b, 0xb8, 0x8b, 0x19, 0xe9, 0x69, 0x6a, 0x55, 0x59, 0xad, 0x6c, 0xdc, 0x3d, 0x87, 0x6f, 0xfa,
	0xb2, 0x7a, 0x52, 0x15, 0xea, 0x82, 0x9a, 0x00, 0x1e, 0x1b, 0xbe, 0x76, 0x4b, 0xb8, 0x7e, 0xf3,
	0x9c, 0xae, 0x4f, 0xe8, 0x90, 0xbe, 0x1f, 0x51, 0x8d, 0x6a, 0x30, 0x65, 0x10, 0xf3, 0xd8, 0x66,
	0xd8, 0x64, 0x01, 0xc1, 0xda, 0x9c, 0x08, 0xfc, 0x04, 0x86, 0x6e, 0xc0, 0xf4, 0x09, 0x26, 0x2e,
	0x76, 0x9e, 0x63, 0x42, 0x6d, 0xcf, 0xd5, 0x90, 0x60, 0x4a, 0x82, 0x7c, 0x6d, 0xf9, 0x8e, 0xc1,
	0x8e, 0x3c, 0xd2, 0xd5, 0xe6, 0xe5, 0xda, 0x8a, 0xde, 0xd1, 0x2a, 0xcc, 0x46, 0xcf, 0x91, 0x8e,
	0x05, 0xc1, 0x32, 0x0c, 0xa3, 0x5f, 0x28, 0x70, 0xd9, 0xf4, 0xba, 0xbe, 0xed, 0x18, 0x7c, 0x22,
	0xfd, 0xb1, 0xd6, 0x7b, 0x9b, 0x94, 0x62, 0xa6, 0x2d, 0x0a, 0x57, 0x3c, 0x3a, 0x9f, 0x2b, 0x32,
	0xd5, 0x49, 0xaf, 0x9c, 0x66, 0x10, 0x1d, 0xc3, 0x45, 0x39, 0xcf, 0x5d, 0x6c, 0x58, 0x98, 0xec,
	0x60, 0x66, 0x1e, 0xeb, 0x98, 0x06, 0x0e, 0xd3, 0xde, 0x12, 0x91, 0xb4, 0x9e, 0x31, 0x96, 0x87,
	0xe9, 0x52, 0x7a, 0x96, 0x3a, 0xd4, 0x83, 0x85, 0xad, 0x27, 0xfa, 0xf6, 0xc8, 0x94, 0xd7, 0xc4,
	0x94, 0xb7, 0xcf, 0x35, 0xe5, 0x14, 0x3d, 0x72, 0xae, 0xa9, 0x26, 0xd0, 0x3a, 0xa0, 0x26, 0xc1,
	0x87, 0x81, 0xed, 0xb0, 0xed, 0x7a, 0x73, 0x47, 0x80, 0x54, 0xbb, 0x5d, 0xcd, 0xaf, 0x96, 0xf5,
	0x14, 0x0a, 0xba, 0x0b, 0x13, 0xc4, 0x0b, 0x18, 0xa6, 0xda, 0x55, 0x31, 0xb8, 0x2b, 0x19, 0x83,
	0xd3, 0x39, 0x93, 0x1e, 0xf2, 0xa2, 0x7d, 0x98, 0x16, 0x4f, 0x8f, 0x31, 0x33, 0x38, 0xbf, 0x56,
	0x13, 0xc2, 0x37, 0x4e, 0x13, 0x8e, 0x78, 0xf5, 0xa4, 0x28, 0xfa, 0x6f, 0x40, 0x82, 0x6b, 0xcb,
	0x73, 0x8f, 0xec, 0x4e, 0x40, 0xc4, 0xc7, 0xd3, 0xae, 0x8b, 0x75, 0xf8, 0x56, 0x86, 0xc2, 0xcd,
	0x11, 0x01, 0x3d, 0x45, 0x09, 0x5a, 0x01, 0x08, 0xf7, 0x93, 0xc6, 0x41, 0x4b, 0x9b, 0x11, 0x3b,
	0x4c, 0x0c, 0xe1, 0xbb, 0xb8, 0xe5, 0x75, 0x0d, 0xdb, 0xa5, 0xda, 0x8a, 0xf0, 0x50, 0xf4, 0x8a,
	0xee, 0xc2, 0x62, 0xc4, 0x27, 0x90, 0x86, 0xc1, 0x8c, 0x43, 0x83, 0x62, 0xed, 0x86, 0x50, 0x92,
	0x4e, 0x44, 0xb7, 0x61, 0x2e, 0x22, 0xb8, 0xf4, 0x91, 0xe7, 0x9d, 0x04, 0x3e, 0xd5, 0xde, 0x14,
	0x12, 0xa3, 0x04, 0xf4, 0x02, 0xe6, 0xa3, 0xed, 0x9a, 0xef, 0x47, 0xb4, 0xde, 0x13, 0xd9, 0x6c,
	0x55, 0xb8, 0xb2, 0xf1, 0x43, 0xb2, 0x41, 0x4c, 0x8d, 0x8c, 0x91, 0x34, 0x03, 0x7c, 0xd6, 0xd8,
	0xa4, 0x6d, 0x83, 0x9e, 0x68, 0xef, 0x88, 0xa5, 0x1b, 0xbd, 0x2e, 0x77, 0x61, 0x29, 0x3d, 0xb1,
	0x20, 0x15, 0xf2, 0x27, 0xb8, 0xa7, 0x29, 0x82, 0x9f, 0x3f, 0xa2, 0x4f, 0xa0, 0xf8, 0xc2, 0x70,
	0x02, 0x99, 0x7d, 0x2b, 0x1b, 0xb7, 0xb2, 0x3e, 0x7d, 0xa8, 0xa7, 0xff, 0xf5, 0xa5, 0xd4, 0x47,
	0xb9, 0x0f, 0x95, 0xe5, 0x3a, 0xcf, 0xed, 0xa3, 0x79, 0x25, 0x6e, 0xac, 0x28, 0x8d, 0x2d, 0xc4,
	0x8d, 0x95, 0xe3, 0x3a, 0xb6, 0x60, 0x31, 0x75, 0x83, 0x4c, 0x19, 0x71, 0x42, 0x49, 0x3e, 0xae,
	0xe4, 0xa7, 0x0a, 0x54, 0xc7, 0xed, 0x2d, 0x29, 0x0a, 0x77, 0x93, 0x2e, 0xd8, 0xc8, 0x72, 0x41,
	0xe0, 0x32, 0xbb, 0x8b, 0xd3, 0x0c, 0xc4, 0x07, 0xf1, 0x25, 0x5c, 0xca, 0x5c, 0xec, 0x29, 0xc6,
	0x3f, 0x88, 0x1b, 0x9f, 0xc9, 0x2e, 0x60, 0x9e, 0xe8, 0xdb, 0xe1, 0x76, 0x15, 0xb3, 0x65, 0x82,
	0x96, 0x15, 0x33, 0x29, 0xa6, 0xde, 0x4b, 0xce, 0xf3, 0x72, 0x86, 0x29, 0xae, 0x29, 0x66, 0x64,
	0xbf, 0x50, 0x52, 0xd4, 0xdc, 0x7e, 0xa1, 0x54, 0x50, 0x8b, 0xfb, 0x85, 0xd2, 0xa4, 0x5a, 0xda,
	0x2f, 0x94, 0xca, 0x2a, 0xec, 0x17, 0x4a, 0xd3, 0xea, 0xcc, 0x7e, 0xa1, 0x54, 0x55, 0xaf, 0xed,
	0x17, 0x4a, 0xd7, 0xd4, 0x5a, 0xed, 0x5b, 0x80, 0x4a, 0xbc, 0xb8, 0xfb, 0x00, 0x8a, 0x3c, 0xbd,
	0x51, 0x4d, 0x39, 0x6b, 0x71, 0x26, 0xf9, 0xd1, 0x27, 0x90, 0xb7, 0x5c, 0xaa, 0xe5, 0x84, 0xd8,
	0xdb, 0x63, 0xc5, 0xe8, 0x7a, 0xc3, 0x0d, 0x2b, 0x27, 0x2e, 0x87, 0x9e, 0x0e, 0x57, 0x03, 0x79,
	0x31, 0xe1, 0x33, 0x28, 0xca, 0x2c, 0x02, 0x62, 0x5b, 0x4c, 0x61, 0x78, 0x8b, 0x89, 0x76, 0xde,
	0xe2, 0x39, 0x76, 0xde, 0x9f, 0x8f, 0xc9, 0xaa, 0x13, 0x42, 0xd7, 0xd6, 0x19, 0xa6, 0xfe, 0xcf,
	0x25, 0xd3, 0xf4, 0x5d, 0x7b, 0xf2, 0x75, 0xec, 0xda, 0x08, 0x0a, 0x8c, 0x57, 0x84, 0x25, 0xe1,
	0x2f, 0xf1, 0x8c, 0xac, 0x94, 0x5a, 0xaa, 0x2c, 0xa6, 0xfa, 0xe1, 0x99, 0xa6, 0x7a, 0xb6, 0x12,
	0xea, 0x94, 0x0a, 0x01, 0x5e, 0x6f, 0x85, 0xe0, 0x67, 0x54, 0x08, 0x15, 0x31, 0xa7, 0x8f, 0xcf,
	0x32, 0xa7, 0xd7, 0x52, 0x18, 0x4c, 0x65, 0x15, 0x06, 0xcb, 0x9f, 0x43, 0x29, 0x5a, 0x1c, 0x29,
	0x5b, 0xc2, 0xbd, 0xe4, 0x96, 0x70, 0x35, 0x63, 0xc0, 0x8d, 0x83, 0x96, 0x1c, 0xd3, 0xbf, 0xdb,
	0x66, 0xfb, 0x5a, 0xd2, 0xc6, 0x8f, 0xb8, 0x63, 0xd7, 0x7e, 0xb3, 0x04, 0x30, 0xf8, 0xfc, 0x5c,
	0xbb, 0x6f, 0x5b, 0x51, 0x8a, 0xf4, 0x6d, 0x8b, 0x6f, 0xd2, 0x8e, 0x61, 0x59, 0x44, 0x9c, 0x47,
	0xb3, 0x37, 0xe9, 0x4d, 0xcb, 0x22, 0xba, 0xe4, 0xe4, 0x22, 0x44, 0x88, 0x4c, 0x9c, 0x41, 0x44,
	0x70, 0xa2, 0xff, 0x82, 0x89, 0x23, 0xa3, 0x6b, 0x3b, 0xbd, 0x70, 0x41, 0xdc, 0x1a, 0x1b, 0xa9,
	0x3b, 0x82, 0x5d, 0x0f, 0xc5, 0xd0, 0x7f, 0x40, 0x81, 0xf1, 0xb3, 0x5b, 0x45, 0x88, 0xbf, 0x39,
	0x56, 0x5c, 0x1c, 0xdc, 0x84, 0x08, 0xfa, 0x1f, 0x58, 0xb0, 0xe9, 0x23, 0xcf, 0x34, 0x9c, 0xa6,
	0x47, 0xd8, 0xb6, 0x7f, 0x8c, 0xbb, 0x98, 0x18, 0x4e, 0x58, 0xbc, 0x67, 0x6d, 0x3a, 0x7d, 0x3e,
	0x2e, 0xd4, 0x62, 0x06, 0xc3, 0x7a, 0xaa, 0x1a, 0x7e, 0x36, 0x72, 0x0c, 0xca, 0xea, 0x3d, 0x86,
	0x69, 0x0b, 0xbb, 0x4c, 0x1c, 0x05, 0x0b, 0x7a, 0x12, 0xe4, 0x25, 0x5e, 0x1f, 0xd0, 0xb1, 0x89,
	0xed, 0x17, 0xd8, 0x12, 0x47, 0xad, 0x82, 0x3e, 0x4a, 0xe0, 0xa7, 0x25, 0x0e, 0xea, 0x98, 0x11,
	0xc3, 0xa5, 0x5d, 0x9b, 0x51, 0x71, 0xe2, 0x9a, 0xd6, 0x87, 0x61, 0xb4, 0x0b, 0x65, 0xcb, 0x26,
	0x72, 0xce, 0xe2, 0xd0, 0x35, 0xb3, 0xb1, 0x36, 0xd6, 0x39, 0x8d, 0x48, 0x42, 0x1f, 0x08, 0x47,
	0x36, 0x9b, 0x86, 0x79, 0x82, 0x99, 0x9c, 0xc9, 0x4d, 0x31, 0xbe, 0x61, 0x18, 0xbd, 0x0b, 0xf3,
	0x31, 0xa8, 0x3f, 0x9b, 0x5b, 0x82, 0x3b, 0x8d, 0x84, 0x1e, 0x40, 0x49, 0xf4, 0x65, 0x4c, 0xcf,
	0xd1, 0xde, 0x15, 0x41, 0x93, 0x55, 0xf2, 0x37, 0x43, 0xb6, 0x16, 0x33, 0xcc, 0x13, 0xbd, 0x2f,
	0xc5, 0x57, 0x93, 0x8b, 0xd9, 0x41, 0x4b, 0x9c, 0x1a, 0xa7, 0x75, 0xf9, 0xc2, 0xc7, 0x4c, 0x70,
	0xd7, 0x63, 0xf8, 0xa0, 0xdf, 0xb7, 0xa9, 0xca, 0x53, 0xe5, 0x10, 0xcc, 0x4f, 0x1e, 0xb6, 0xdf,
	0xe6, 0x6e, 0x93, 0xab, 0x5b, 0x5b, 0x3c, 0x75, 0x18, 0x7b, 0xcd, 0x18, 0xaf, 0x9e, 0x14, 0xe5,
	0x8b, 0x88, 0x30, 0xa6, 0x2d, 0x89, 0x91, 0xf0, 0x47, 0xb4, 0x04, 0x13, 0x84, 0xb1, 0xe7, 0x06,
	0xd1, 0x2e, 0x0a, 0x30, 0x7c, 0x43, 0x57, 0xa0, 0x6c, 0xbb, 0x8c, 0x18, 0xbc, 0xc4, 0xd1, 0xb4,
	0xaa, 0xb2, 0x5a, 0xd2, 0x07, 0x00, 0xba, 0x0f, 0x4b, 0x96, 0x4b, 0x5b, 0x81, 0xc9, 0x0d, 0x1f,
	0x05, 0x8e, 0x8e, 0xa9, 0xef, 0xb9, 0x14, 0x53, 0xed, 0x92, 0xd0, 0x92, 0x41, 0xe5, 0x5b, 0xb2,
	0xe5, 0xd2, 0x1d, 0xc3, 0x76, 0x44, 0xbd, 0x1d, 0xca, 0x2c, 0x0b, 0x99, 0x14, 0x0a, 0xaa, 0x42,
	0xc5, 0x72, 0x69, 0xdb, 0xee, 0x62, 0x2f, 0x60, 0x54, 0xbb, 0x2c, 0x18, 0xe3, 0x10, 0xda, 0x80,
	0x85, 0x81, 0xad, 0x47, 0x06, 0xc3, 0xae, 0xd9, 0x6b, 0x05, 0x5d, 0xed, 0x8a, 0xf8, 0xa4, 0xa9,
	0xb4, 0x50, 0x86, 0xdb, 0x0a, 0x08, 0x8e, 0xc9, 0xbc, 0xd1, 0x97, 0x19, 0xa1, 0xa1, 0xff, 0x87,
	0x59, 0xcb, 0xa5, 0x5b, 0x5e, 0xe0, 0xb2, 0x7a, 0x4f, 0xe7, 0x07, 0x1b, 0xed, 0x9a, 0xc8, 0x5c,
	0xf7, 0xc7, 0xc6, 0x2c, 0x2f, 0xb9, 0xe2, 0x82, 0x61, 0x2b, 0x69, 0x48, 0x1d, 0xf7, 0x0d, 0x0f,
	0xc0, 0xb6, 0xe9, 0x6f, 0x53, 0x66, 0x1c, 0x3a, 0x36, 0x3d, 0xc6, 0x96, 0xb6, 0x22, 0x7d, 0x33,
	0x4a, 0x89, 0x56, 0x6f, 0xdb, 0xf4, 0xb7, 0x1c, 0x8f, 0x62, 0x4b, 0xbb, 0x2a, 0x58, 0x93, 0x20,
	0x32, 0x41, 0xe5, 0x3e, 0x60, 0x06, 0x2f, 0x79, 0xe5, 0xe1, 0x2d, 0x3c, 0xba, 0x7e, 0x70, 0xa6,
	0x81, 0x27, 0x24, 0xc3, 0x2a, 0x62, 0x58, 0x21, 0xfa, 0x99, 0x02, 0x97, 0x87, 0xc1, 0x7a, 0xef,
	0x69, 0x80, 0x49, 0x4f, 0xb4, 0xad, 0xd6, 0xc6, 0xb4, 0xfb, 0x32, 0x0d, 0xc6, 0x94, 0x84, 0x15,
	0xda, 0x29, 0x66, 0xd0, 0x37, 0x0a, 0x5c, 0x1b, 0xa6, 0x3f, 0x39, 0x3a, 0xa2, 0x98, 0xc5, 0x07,
	0xf3, 0xb6, 0x18, 0xcc, 0xee, 0xf9, 0x07, 0x33, 0xa2, 0x4a, 0x0e, 0x69, 0xbc, 0x49, 0xb4, 0x0c,
	0x25, 0x51, 0xcc, 0xee, 0x59, 0x5f, 0x89, 0xe3, 0x74, 0x51, 0xef, 0xbf, 0xa3, 0x9b, 0x30, 0x23,
	0x9e, 0xdb, 0x06, 0xe9, 0x60, 0xc6, 0x39, 0x56, 0x05, 0xc7, 0x10, 0x8a, 0xd6, 0x40, 0x3d, 0x66,
	0xcc, 0xdf, 0xec, 0x74, 0x08, 0xee, 0x18, 0xb2, 0x93, 0x2b, 0x0f, 0xda, 0x23, 0x38, 0x5a, 0x0a,
	0xeb, 0xc9, 0xdb, 0xd5, 0xfc, 0xea, 0x74, 0x3d, 0xa7, 0x5e, 0x08, 0x6b, 0x4a, 0x0d, 0x26, 0xf9,
	0x2f, 0x37, 0xf2, 0x8e, 0xec, 0xe1, 0x86, 0xaf, 0xa8, 0x06, 0x53, 0xfc, 0x71, 0xeb, 0x18, 0x9b,
	0x27, 0x34, 0xe8, 0x6a, 0x77, 0x44, 0x2c, 0x25, 0x30, 0xb4, 0x02, 0x40, 0x79, 0x36, 0xd9, 0x73,
	0x2d, 0xfc, 0x95, 0xb6, 0x2e, 0x38, 0x62, 0x08, 0xfa, 0x10, 0x2e, 0x72, 0x9f, 0xb6, 0x18, 0xc1,
	0x46, 0x97, 0x26, 0x06, 0xfa, 0x9e, 0x18, 0x68, 0x16, 0x99, 0xa7, 0x18, 0x3e, 0x87, 0x8d, 0x84,
	0xcc, 0x86, 0xec, 0x22, 0x8c, 0x10, 0xc4, 0xf2, 0x0d, 0xfb, 0x0f, 0x09, 0x81, 0xf7, 0x85, 0x40,
	0x2a, 0x0d, 0x79, 0xb0, 0xc0, 0x4c, 0x3f, 0x5c, 0xd6, 0xb4, 0xde, 0xdb, 0x26, 0x64, 0x8b, 0xaf,
	0xe1, 0xbb, 0x22, 0x18, 0xfe, 0x73, 0x7c, 0x30, 0xb4, 0x53, 0xa4, 0xc3, 0xe2, 0x33, 0x4d, 0x31,
	0x5f, 0x9d, 0x72, 0x23, 0xdf, 0x0e, 0x1b, 0x0f, 0xf7, 0x64, 0xdf, 0x31, 0x01, 0x2e, 0xd7, 0x61,
	0x21, 0x6d, 0x73, 0x88, 0x97, 0x52, 0xd3, 0x29, 0x35, 0xd9, 0x74, 0xbc, 0x26, 0xb3, 0x60, 0x31,
	0x75, 0x9d, 0xa6, 0x34, 0x15, 0xce, 0x5e, 0xc3, 0x0a, 0x75, 0x71, 0x2b, 0x5f, 0x43, 0x75, 0xdc,
	0xe2, 0x4c, 0x31, 0xf8, 0x20, 0x69, 0x70, 0x6d, 0x8c, 0xc1, 0x98, 0xc6, 0xb8, 0xed, 0x9f, 0x28,
	0x70, 0xf3, 0x6c, 0x8b, 0xf1, 0x5f, 0x36, 0x84, 0xcf, 0xe0, 0x52, 0x66, 0x04, 0x9c, 0xe7, 0x6b,
	0xed, 0x17, 0x4a, 0x39, 0x35, 0xbf, 0x5f, 0x28, 0xe5, 0xd5, 0xc2, 0x50, 0xa3, 0xa0, 0xa4, 0x96,
	0xfb, 0xed, 0x82, 0x29, 0x75, 0xba, 0xdf, 0x34, 0x98, 0x51, 0x67, 0xf7, 0x0b, 0xa5, 0x59, 0x55,
	0xdd, 0x2f, 0x94, 0xae, 0xab, 0x37, 0x6a, 0xdf, 0x28, 0xa0, 0x0e, 0xf7, 0x98, 0xd0, 0x0c, 0xe4,
	0xc2, 0xe2, 0xb8, 0xac, 0xe7, 0x6c, 0x8b, 0xaf, 0xf4, 0xc3, 0x1e, 0xc3, 0x0f, 0xb1, 0x3c, 0xd1,
	0x4f, 0xe9, 0xd1, 0x6b, 0xff, 0xac, 0x59, 0x88, 0x9d, 0x35, 0x97, 0xa1, 0xc4, 0x8c, 0x8e, 0x5c,
	0xd7, 0xf2, 0x72, 0xa7, 0xff, 0x1e, 0xed, 0x0c, 0x8f, 0x3d, 0xcb, 0x3e, 0xb2, 0xb1, 0x25, 0x2a,
	0xe7, 0xbc, 0x9e, 0xc0, 0xe4, 0xa4, 0x6a, 0xdf, 0x16, 0x45, 0x77, 0x6b, 0xa4, 0x41, 0x80, 0x3e,
	0x86, 0x4b, 0x5d, 0xcf, 0xf5, 0x98, 0xe7, 0xda, 0xe6, 0x43, 0x9f, 0x78, 0x87, 0x98, 0xb6, 0x89,
	0xdd, 0xe9, 0x60, 0x82, 0xe5, 0x98, 0xf3, 0x7a, 0x36, 0x03, 0xaf, 0x35, 0x86, 0x89, 0x8f, 0x6d,
	0xca, 0x13, 0x9e, 0x3c, 0x9e, 0x64, 0x50, 0xd1, 0x03, 0xb8, 0xdc, 0xa7, 0xf0, 0x61, 0x31, 0xc2,
	0xeb, 0x32, 0xdc, 0xb1, 0x29, 0xc3, 0x84, 0x0a, 0xb7, 0xe4, 0xf5, 0xd3, 0x58, 0xd0, 0x01, 0xd4,
	0x4e, 0x21, 0x37, 0x88, 0xe7, 0xfb, 0xd8, 0xd2, 0x0a, 0x42, 0xd1, 0x19, 0x38, 0x51, 0x1d, 0xae,
	0xf4, 0xb9, 0x1a, 0x2e, 0x0d, 0x4b, 0xcd, 0xa6, 0x8c, 0x43, 0x2c, 0xef, 0xd5, 0xf2, 0xfa, 0xa9,
	0x3c, 0x7c, 0xf3, 0x4b, 0x58, 0xa2, 0x61, 0xf2, 0x97, 0x9f, 0x25, 0x95, 0xc6, 0x6b, 0x4d, 0xd1,
	0x2c, 0xaa, 0xfb, 0x47, 0x8f, 0x0d, 0x79, 0x4d, 0x37, 0x29, 0xd8, 0x87, 0x61, 0xf4, 0x29, 0x2c,
	0xf7, 0x35, 0x3c, 0xb3, 0xfc, 0x16, 0x76, 0xad, 0xd8, 0xf8, 0x4a, 0x42, 0xe8, 0x14, 0x0e, 0x9e,
	0x02, 0x46, 0xa8, 0xe1, 0xc7, 0x2a, 0x0b, 0xe1, 0x2c, 0x32, 0xfa, 0x08, 0x34, 0x33, 0x72, 0x5c,
	0xcb, 0xe8, 0xfa, 0x8e, 0xed, 0x76, 0x9a, 0x98, 0x98, 0xbc, 0x98, 0x07, 0x21, 0x9a, 0x49, 0xe7,
	0xf3, 0x8b, 0x72, 0x70, 0xf4, 0x51, 0x2a, 0x72, 0x7e, 0x43, 0x70, 0xed, 0xb7, 0x05, 0x78, 0xe3,
	0xd4, 0x1b, 0x2d, 0x9e, 0x66, 0x4f, 0xd2, 0x43, 0x74, 0x04, 0x17, 0x77, 0x4b, 0x29, 0x01, 0x99,
	0x04, 0x79, 0x5d, 0x67, 0x66, 0x85, 0x5f, 0x0a, 0x85, 0xaf, 0x16, 0x73, 0x4c, 0xb0, 0x65, 0x33,
	0xf0, 0x13, 0x8e, 0x95, 0x19, 0x5a, 0x69, 0x24, 0x5e, 0x63, 0x9b, 0x23, 0x81, 0x14, 0x87, 0xce,
	0x11, 0x3f, 0xb7, 0x61, 0x2e, 0xc8, 0x08, 0x9b, 0x51, 0x02, 0x2f, 0x7d, 0x82, 0xb4, 0x20, 0x19,
	0x42, 0x7f, 0xa4, 0xd8, 0xf8, 0x6b, 0x0e, 0x2e, 0x9f, 0xd2, 0x4b, 0xe1, 0xdf, 0x85, 0x8c, 0x90,
	0xb7, 0x5d, 0xe3, 0xd0, 0x09, 0x43, 0xa4, 0xa4, 0x67, 0x33, 0xa0, 0x13, 0xd0, 0x46, 0x89, 0x61,
	0xa7, 0x4d, 0x76, 0x47, 0xee, 0x9c, 0xb9, 0xbf, 0x13, 0xf6, 0x4a, 0x32, 0x15, 0xf2, 0x65, 0x3c,
	0x4a, 0x6b, 0x44, 0x2d, 0x4b, 0x19, 0x7a, 0xa7, 0x70, 0x9c, 0xd6, 0x15, 0x2c, 0xbc, 0xd6, 0xae,
	0x60, 0xed, 0x0f, 0x0a, 0xa0, 0xcd, 0xd4, 0x6b, 0x2c, 0xd7, 0xef, 0x26, 0x9d, 0x1b, 0x43, 0x38,
	0x3d, 0xa0, 0x7d, 0x7a, 0x4e, 0xd2, 0x07, 0x08, 0xa7, 0x5b, 0x03, 0x7a, 0x5e, 0xd2, 0xad, 0x04,
	0xdd, 0x34, 0xfb, 0xf4, 0x82, 0xa4, 0x0f, 0x10, 0x41, 0x1f, 0xc8, 0x17, 0x43, 0x7a, 0x1f, 0xa9,
	0x7d, 0x0a, 0x45, 0xd1, 0xa4, 0x46, 0xf7, 0x60, 0x82, 0x06, 0x87, 0x2e, 0x66, 0x62, 0x90, 0x95,
	0x8d, 0x37, 0x32, 0x1c, 0xd3, 0x12, 0x4c, 0x7a, 0xc8, 0x5c, 0x5b, 0x81, 0x09, 0x89, 0xf0, 0x4a,
	0xc1, 0x70, 0x6c, 0x83, 0x86, 0xb9, 0x5b, 0xbe, 0xd4, 0x7a, 0x30, 0x9d, 0xb8, 0x41, 0x4c, 0x67,
	0x4b, 0xe4, 0xed, 0xdc, 0x98, 0xbc, 0x9d, 0x1f, 0xcd, 0xdb, 0x69, 0xb5, 0x40, 0xed, 0x97, 0x0a,
	0x4c, 0x27, 0x7a, 0x08, 0xe8, 0x0a, 0x94, 0x09, 0xf6, 0x9d, 0x16, 0x31, 0xf7, 0x9a, 0xa1, 0xfd,
	0x01, 0x10, 0x51, 0x1b, 0x94, 0xed, 0x35, 0xc3, 0xcb, 0xaa, 0x01, 0xc0, 0x37, 0x97, 0x90, 0xb5,
	0xe9, 0x11, 0x26, 0x06, 0x51, 0xd4, 0xe3, 0x50, 0xc4, 0xd1, 0xa0, 0x4c, 0x70, 0x14, 0x06, 0x1c,
	0x21, 0x54, 0xfb, 0x1a, 0x0a, 0x9b, 0x96, 0x45, 0x44, 0x8d, 0xe3, 0x87, 0x26, 0x72, 0xb6, 0xcf,
	0x47, 0xef, 0x0f, 0x94, 0x8a, 0xe7, 0x70, 0x33, 0x93, 0x17, 0x6c, 0xe1, 0x3f, 0x55, 0xca, 0x7a,
	0x1c, 0x4a, 0xfc, 0x8d, 0x66, 0x32, 0xf9, 0x37, 0x9a, 0xa1, 0xfb, 0x9b, 0x09, 0x75, 0xb2, 0x76,
	0x00, 0xd3, 0x89, 0xbe, 0x0e, 0xfa, 0x04, 0x8a, 0x94, 0x3f, 0x88, 0x8b, 0x9a, 0x99, 0x8d, 0xeb,
	0x63, 0x9a, 0x41, 0xbc, 0x8e, 0x14, 0x07, 0x30, 0x29, 0x55, 0xab, 0x42, 0x29, 0xea, 0x10, 0x8b,
	0xc6, 0x90, 0xd1, 0xc5, 0xf2, 0xce, 0xa7, 0xac, 0xcb, 0x97, 0xda, 0x1f, 0x73, 0x82, 0x45, 0x6c,
	0x4d, 0xc3, 0xfd, 0x0f, 0xe5, 0xec, 0xfd, 0x8f, 0xdc, 0x0f, 0xe8, 0x7f, 0xe4, 0x4f, 0xe9, 0x7f,
	0xfc, 0xef, 0x68, 0xff, 0xa3, 0x20, 0xce, 0x4e, 0x77, 0xc7, 0x14, 0xd4, 0x67, 0xeb, 0x7e, 0xbc,
	0x8e, 0x93, 0x50, 0xed, 0x6f, 0x0a, 0xcc, 0xa7, 0xd4, 0xf1, 0x28, 0x10, 0x39, 0x71, 0x18, 0x0e,
	0xaf, 0xda, 0xb6, 0xce, 0x7e, 0x20, 0x88, 0x75, 0x04, 0x86, 0x7a, 0x00, 0x69, 0xfa, 0x97, 0x3b,
	0xa0, 0x65, 0x09, 0xbc, 0xd6, 0xb3, 0xd9, 0xda, 0xaf, 0x73, 0xa0, 0x65, 0x65, 0x09, 0xa4, 0xc2,
	0xd4, 0x81, 0xc7, 0x36, 0x19, 0xc3, 0x5d, 0x9f, 0x61, 0x4b, 0xbd, 0x80, 0x96, 0x00, 0xc5, 0xd8,
	0xc2, 0xf0, 0x50, 0x15, 0xb4, 0x00, 0xea, 0xc3, 0xf8, 0xbf, 0x62, 0xb6, 0x09, 0x51, 0x73, 0x68,
	0x11, 0xe6, 0x9e, 0x63, 0x62, 0x1f, 0xd9, 0xa6, 0xcc, 0x67, 0x84, 0x78, 0x44, 0xcd, 0x73, 0xb5,
	0x4f, 0x02, 0xe6, 0x07, 0xac, 0x61, 0x13, 0xce, 0x58, 0x40, 0x73, 0x30, 0x2d, 0x91, 0x1d, 0xdb,
	0xc1, 0x1c, 0x2a, 0x22, 0x04, 0x33, 0x07, 0xf8, 0xa5, 0x34, 0x86, 0x05, 0xdb, 0x04, 0xc7, 0xe2,
	0xe9, 0x91, 0x10, 0x75, 0x92, 0x8b, 0x86, 0x89, 0x02, 0x1b, 0x16, 0x87, 0x4a, 0x9c, 0x2d, 0x96,
	0x2d, 0x38, 0x56, 0x46, 0x17, 0x61, 0x3e, 0xd4, 0x65, 0x85, 0x96, 0xbc, 0xc0, 0xb5, 0x54, 0xe0,
	0xcc, 0x7b, 0xae, 0x1f, 0xb0, 0x5d, 0x83, 0x1e, 0xcb, 0x01, 0x56, 0xd6, 0x7e, 0x9f, 0x83, 0x8b,
	0x19, 0xe9, 0x88, 0xcf, 0x49, 0xbc, 0xa6, 0x38, 0x26, 0xa0, 0xcc, 0xeb, 0x4a, 0x09, 0x2a, 0xd5,
	0x2b, 0xdc, 0x6e, 0x03, 0x1f, 0x19, 0x81, 0xc3, 0x12, 0x04, 0xe1, 0x9b, 0x56, 0x8f, 0x1e, 0xd1,
	0x04, 0x9c, 0x47, 0xcb, 0xb0, 0xd4, 0xf0, 0x5e, 0xba, 0x8e, 0x67, 0x58, 0xd8, 0x4a, 0xd0, 0x0a,
	0x68, 0x1e, 0x66, 0x23, 0x5a, 0xe4, 0x79, 0xe1, 0xa7, 0x5d, 0x8f, 0xb2, 0x98, 0xdf, 0x27, 0xe2,
	0x8c, 0xe1, 0x6a, 0x54, 0x27, 0xc5, 0xc7, 0x30, 0x1c, 0xdb, 0x32, 0xe4, 0x3d, 0x83, 0x84, 0x4b,
	0xe8, 0x12, 0x2c, 0xea, 0xd8, 0xf7, 0x68, 0xc3, 0x26, 0x9b, 0x42, 0x67, 0x44, 0x2a, 0xa3, 0xeb,
	0x70, 0x35, 0x1c, 0xc1, 0x81, 0x27, 0xfd, 0x15, 0x69, 0x6d, 0xd8, 0x54, 0x24, 0x33, 0x15, 0xd6,
	0x7e, 0xa7, 0x00, 0x0c, 0x2e, 0x61, 0x78, 0x20, 0x84, 0x63, 0x93, 0xee, 0xa8, 0xb7, 0x77, 0xa4,
	0x77, 0x42, 0x74, 0xbb, 0x7b, 0x88, 0x2d, 0x0b, 0x5b, 0x1c, 0x57, 0x84, 0x13, 0x24, 0x1e, 0x3a,
	0x89, 0xc3, 0x39, 0x34, 0x0b, 0x95, 0x3a, 0x3b, 0x8a, 0x8c, 0xaa, 0x79, 0x3e, 0x49, 0x71, 0x59,
	0x14, 0x7e, 0x63, 0x2f, 0x8c, 0x19, 0x19, 0x5c, 0x22, 0x3a, 0x3c, 0x1e, 0x33, 0xb3, 0x50, 0x79,
	0xc4, 0x1d, 0x17, 0x02, 0x13, 0x6b, 0x35, 0x50, 0x87, 0xef, 0x56, 0xd0, 0x04, 0xe4, 0x5e, 0xdc,
	0x55, 0x2f, 0x88, 0xdf, 0xfb, 0xaa, 0xb2, 0xf6, 0x39, 0x8f, 0x8c, 0x91, 0x3b, 0x02, 0xae, 0x2b,
	0x70, 0xa9, 0x8f, 0x4d, 0x91, 0xee, 0xd4, 0x0b, 0x68, 0x0a, 0x4a, 0xb6, 0x6b, 0x7a, 0x5d, 0xdb,
	0xed, 0xa8, 0x0a, 0x7f, 0xf3, 0x02, 0xd6, 0xf1, 0xf8, 0x5b, 0x0e, 0x95, 0xa1, 0xe8, 0x78, 0xa6,
	0xe1, 0xa8, 0x79, 0x54, 0x82, 0x82, 0xeb, 0xb9, 0x58, 0x2d, 0xac, 0x3d, 0x03, 0x34, 0x7a, 0x9d,
	0x82, 0x34, 0x58, 0xc0, 0x11, 0xfa, 0x2c, 0x61, 0x60, 0x0e, 0xa6, 0xfb, 0x94, 0x36, 0x09, 0xb0,
	0xaa, 0xf0, 0x79, 0xf7, 0xa1, 0x1d, 0xc3, 0xa1, 0x58, 0xcd, 0xad, 0xfd, 0x5d, 0x81, 0xa9, 0x78,
	0x8a, 0xe0, 0x1a, 0xa3, 0x0b, 0x83, 0x67, 0xae, 0xe9, 0x18, 0x94, 0x46, 0x1a, 0xe7, 0x61, 0x76,
	0x40, 0x39, 0x71, 0xbd, 0x97, 0xae, 0xaa, 0xf0, 0xd5, 0x17, 0x81, 0xbb, 0xed, 0x76, 0x53, 0xcd,
	0x71, 0xc3, 0x71, 0x64, 0x43, 0xcd, 0xf3, 0xd9, 0x47, 0x50, 0xfb, 0x51, 0x4b, 0x7a, 0x3b, 0x02,
	0x1e, 0x1a, 0x47, 0x27, 0x86, 0x5a, 0x8c, 0x43, 0x8f, 0x3d, 0xb7, 0xe3, 0xa9, 0x13, 0xfc, 0xeb,
	0x47, 0x50, 0xd3, 0xa3, 0xac, 0x43, 0x30, 0x55, 0x27, 0xe3, 0x16, 0x37, 0x1f, 0x3f, 0x6d, 0xaa,
	0xa5, 0xb8, 0xa8, 0x8e, 0x2d, 0x9b, 0xaa, 0xe5, 0x84, 0xb6, 0x5e, 0xeb, 0xe9, 0x23, 0x15, 0xe2,
	0x72, 0x9f, 0xe9, 0xcd, 0x2d, 0xb5, 0x52, 0xdf, 0xfe, 0xd3, 0xf7, 0x2b, 0xca, 0x77, 0xdf, 0xaf,
	0x28, 0x7f, 0xf9, 0x7e, 0x45, 0xf9, 0xd5, 0xab, 0x95, 0x0b, 0xdf, 0xbd, 0x5a, 0xb9, 0xf0, 0xe7,
	0x57, 0x2b, 0x17, 0xbe, 0x78, 0xbb, 0x63, 0xb3, 0xe3, 0xe0, 0x70, 0xdd, 0xf4, 0xba, 0x77, 0x1a,
	0x06, 0x33, 0x1a, 0x5e, 0x47, 0xfe, 0x35, 0xf6, 0x1d, 0xdf, 0xe8, 0xf1, 0x90, 0xbd, 0xf3, 0xe2,
	0x5e, 0xf4, 0x9f, 0xd9, 0xc3, 0x09, 0xa1, 0xf6, 0xfd, 0x7f, 0x04, 0x00, 0x00, 0xff, 0xff, 0xb4,
	0x5a, 0xe1, 0x24, 0x83, 0x2b, 0x00, 0x00,
}

func (m *CollectorConnections) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorConnections) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorConnections) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.EcsTask) > 0 {
		i -= len(m.EcsTask)
		copy(dAtA[i:], m.EcsTask)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EcsTask)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xea
	}
	if len(m.PrebuiltEBPFAssets) > 0 {
		for iNdEx := len(m.PrebuiltEBPFAssets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PrebuiltEBPFAssets[iNdEx])
			copy(dAtA[i:], m.PrebuiltEBPFAssets[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.PrebuiltEBPFAssets[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xe2
		}
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k := range m.CORETelemetryByAsset {
			v := m.CORETelemetryByAsset[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xd2
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KernelHeaderFetchResult))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc8
	}
	if len(m.ResolvedHostsByName) > 0 {
		for k := range m.ResolvedHostsByName {
			v := m.ResolvedHostsByName[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xc2
		}
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k := range m.ConnTelemetryMap {
			v := m.ConnTelemetryMap[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xba
		}
	}
	if len(m.EncodedConnectionsTags) > 0 {
		i -= len(m.EncodedConnectionsTags)
		copy(dAtA[i:], m.EncodedConnectionsTags)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedConnectionsTags)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb2
	}
	if len(m.EncodedDnsLookups) > 0 {
		i -= len(m.EncodedDnsLookups)
		copy(dAtA[i:], m.EncodedDnsLookups)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedDnsLookups)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if len(m.EncodedDomainDatabase) > 0 {
		i -= len(m.EncodedDomainDatabase)
		copy(dAtA[i:], m.EncodedDomainDatabase)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedDomainDatabase)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if m.AgentConfiguration != nil {
		{
			size, err := m.AgentConfiguration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if len(m.RouteMetadata) > 0 {
		for iNdEx := len(m.RouteMetadata) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.RouteMetadata[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.Routes) > 0 {
		for iNdEx := len(m.Routes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Routes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xfa
		}
	}
	if len(m.Domains) > 0 {
		for iNdEx := len(m.Domains) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Domains[iNdEx])
			copy(dAtA[i:], m.Domains[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Domains[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xf2
		}
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k := range m.CompilationTelemetryByAsset {
			v := m.CompilationTelemetryByAsset[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xaa
		}
	}
	if len(m.PlatformVersion) > 0 {
		i -= len(m.PlatformVersion)
		copy(dAtA[i:], m.PlatformVersion)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.PlatformVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.Platform) > 0 {
		i -= len(m.Platform)
		copy(dAtA[i:], m.Platform)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Platform)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.KernelVersion) > 0 {
		i -= len(m.KernelVersion)
		copy(dAtA[i:], m.KernelVersion)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.KernelVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.Architecture) > 0 {
		i -= len(m.Architecture)
		copy(dAtA[i:], m.Architecture)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Architecture)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.ConnTelemetry != nil {
		{
			size, err := m.ConnTelemetry.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.ContainerHostType != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ContainerHostType))
		i--
		dAtA[i] = 0x78
	}
	if len(m.EncodedDNS) > 0 {
		i -= len(m.EncodedDNS)
		copy(dAtA[i:], m.EncodedDNS)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedDNS)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.NetworkId) > 0 {
		i -= len(m.NetworkId)
		copy(dAtA[i:], m.NetworkId)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.NetworkId)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.EncodedTags) > 0 {
		i -= len(m.EncodedTags)
		copy(dAtA[i:], m.EncodedTags)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedTags)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ContainerForPid) > 0 {
		for k := range m.ContainerForPid {
			v := m.ContainerForPid[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintConnections(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.ResolvedResources) > 0 {
		for k := range m.ResolvedResources {
			v := m.ResolvedResources[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x30
	}
	if m.GroupId != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Connections) > 0 {
		for iNdEx := len(m.Connections) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Connections[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *Connections) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connections) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connections) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PrebuiltEBPFAssets) > 0 {
		for iNdEx := len(m.PrebuiltEBPFAssets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PrebuiltEBPFAssets[iNdEx])
			copy(dAtA[i:], m.PrebuiltEBPFAssets[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.PrebuiltEBPFAssets[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k := range m.CORETelemetryByAsset {
			v := m.CORETelemetryByAsset[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KernelHeaderFetchResult))
		i--
		dAtA[i] = 0x50
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k := range m.ConnTelemetryMap {
			v := m.ConnTelemetryMap[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.AgentConfiguration != nil {
		{
			size, err := m.AgentConfiguration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k := range m.CompilationTelemetryByAsset {
			v := m.CompilationTelemetryByAsset[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Routes) > 0 {
		for iNdEx := len(m.Routes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Routes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Domains) > 0 {
		for iNdEx := len(m.Domains) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Domains[iNdEx])
			copy(dAtA[i:], m.Domains[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Domains[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.ConnTelemetry != nil {
		{
			size, err := m.ConnTelemetry.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Dns) > 0 {
		for k := range m.Dns {
			v := m.Dns[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Conns) > 0 {
		for iNdEx := len(m.Conns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Connection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RemoteEcsTask) > 0 {
		i -= len(m.RemoteEcsTask)
		copy(dAtA[i:], m.RemoteEcsTask)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.RemoteEcsTask)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xaa
	}
	if len(m.TcpFailuresByErrCode) > 0 {
		for k := range m.TcpFailuresByErrCode {
			v := m.TcpFailuresByErrCode[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xa2
		}
	}
	if len(m.DatabaseAggregations) > 0 {
		i -= len(m.DatabaseAggregations)
		copy(dAtA[i:], m.DatabaseAggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.DatabaseAggregations)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x9a
	}
	if len(m.Http2Aggregations) > 0 {
		i -= len(m.Http2Aggregations)
		copy(dAtA[i:], m.Http2Aggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Http2Aggregations)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x92
	}
	if len(m.DataStreamsAggregations) > 0 {
		i -= len(m.DataStreamsAggregations)
		copy(dAtA[i:], m.DataStreamsAggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.DataStreamsAggregations)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x8a
	}
	if m.Protocol != nil {
		{
			size, err := m.Protocol.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x82
	}
	if m.TagsChecksum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsChecksum))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf8
	}
	if m.StateIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.StateIndex))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf0
	}
	if m.TagsIdx != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsIdx))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xe8
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i = encodeVarintConnections(dAtA, i, uint64(m.Tags[iNdEx]))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xe0
		}
	}
	if len(m.DnsStatsByDomainOffsetByQueryType) > 0 {
		for k := range m.DnsStatsByDomainOffsetByQueryType {
			v := m.DnsStatsByDomainOffsetByQueryType[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xda
		}
	}
	if len(m.DnsStatsByDomainByQueryType) > 0 {
		for k := range m.DnsStatsByDomainByQueryType {
			v := m.DnsStatsByDomainByQueryType[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xd2
		}
	}
	if m.IsLocalPortEphemeral != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.IsLocalPortEphemeral))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc8
	}
	if m.RouteTargetIdx != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RouteTargetIdx))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc0
	}
	if m.LastPacketsReceived != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastPacketsReceived))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb8
	}
	if m.LastPacketsSent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastPacketsSent))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb0
	}
	if len(m.HttpAggregations) > 0 {
		i -= len(m.HttpAggregations)
		copy(dAtA[i:], m.HttpAggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.HttpAggregations)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if m.RouteIdx != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RouteIdx))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa0
	}
	if len(m.DnsStatsByDomain) > 0 {
		for k := range m.DnsStatsByDomain {
			v := m.DnsStatsByDomain[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.DnsCountByRcode) > 0 {
		for k := range m.DnsCountByRcode {
			v := m.DnsCountByRcode[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x8a
		}
	}
	if len(m.RemoteNetworkId) > 0 {
		i -= len(m.RemoteNetworkId)
		copy(dAtA[i:], m.RemoteNetworkId)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.RemoteNetworkId)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if m.LastTcpClosed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastTcpClosed))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf8
	}
	if m.LastTcpEstablished != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastTcpEstablished))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf0
	}
	if m.DnsFailureLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsFailureLatencySum))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe8
	}
	if m.DnsSuccessLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsSuccessLatencySum))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe0
	}
	if m.DnsTimeouts != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsTimeouts))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd8
	}
	if m.DnsFailedResponses != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsFailedResponses))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.DnsSuccessfulResponses != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsSuccessfulResponses))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if m.IntraHost {
		i--
		if m.IntraHost {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.RttVar != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RttVar))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.Rtt != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Rtt))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.IpTranslation != nil {
		{
			size, err := m.IpTranslation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.NetNS != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.NetNS))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.Direction != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Direction))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.LastRetransmits != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastRetransmits))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.LastBytesReceived != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastBytesReceived))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.LastBytesSent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastBytesSent))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.Type != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x58
	}
	if m.Family != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Family))
		i--
		dAtA[i] = 0x50
	}
	if m.Raddr != nil {
		{
			size, err := m.Raddr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Laddr != nil {
		{
			size, err := m.Laddr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Pid != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ResourceMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TagsModified != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsModified))
		i--
		dAtA[i] = 0x30
	}
	if m.TagIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagIndex))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ByteKey) > 0 {
		i -= len(m.ByteKey)
		copy(dAtA[i:], m.ByteKey)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ByteKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConnectionsTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionsTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectionsTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DnsStatsDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsStatsDropped))
		i--
		dAtA[i] = 0x58
	}
	if m.ConntrackSamplingPercent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackSamplingPercent))
		i--
		dAtA[i] = 0x50
	}
	if m.MonotonicUdpSendsMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicUdpSendsMissed))
		i--
		dAtA[i] = 0x48
	}
	if m.MonotonicUdpSendsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicUdpSendsProcessed))
		i--
		dAtA[i] = 0x40
	}
	if m.ConnsBpfMapSize != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConnsBpfMapSize))
		i--
		dAtA[i] = 0x38
	}
	if m.MonotonicConnsClosed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicConnsClosed))
		i--
		dAtA[i] = 0x30
	}
	if m.MonotonicDnsPacketsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicDnsPacketsProcessed))
		i--
		dAtA[i] = 0x28
	}
	if m.MonotonicConntrackRegistersDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicConntrackRegistersDropped))
		i--
		dAtA[i] = 0x20
	}
	if m.MonotonicConntrackRegisters != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicConntrackRegisters))
		i--
		dAtA[i] = 0x18
	}
	if m.MonotonicKprobesMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicKprobesMissed))
		i--
		dAtA[i] = 0x10
	}
	if m.MonotonicKprobesTriggered != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicKprobesTriggered))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CollectorConnectionsTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorConnectionsTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorConnectionsTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DnsStatsDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsStatsDropped))
		i--
		dAtA[i] = 0x58
	}
	if m.ConntrackSamplingPercent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackSamplingPercent))
		i--
		dAtA[i] = 0x50
	}
	if m.UdpSendsMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.UdpSendsMissed))
		i--
		dAtA[i] = 0x48
	}
	if m.UdpSendsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.UdpSendsProcessed))
		i--
		dAtA[i] = 0x40
	}
	if m.ConnsBpfMapSize != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConnsBpfMapSize))
		i--
		dAtA[i] = 0x38
	}
	if m.ConnsClosed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConnsClosed))
		i--
		dAtA[i] = 0x30
	}
	if m.DnsPacketsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsPacketsProcessed))
		i--
		dAtA[i] = 0x28
	}
	if m.ConntrackRegistersDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackRegistersDropped))
		i--
		dAtA[i] = 0x20
	}
	if m.ConntrackRegisters != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackRegisters))
		i--
		dAtA[i] = 0x18
	}
	if m.KprobesMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KprobesMissed))
		i--
		dAtA[i] = 0x10
	}
	if m.KprobesTriggered != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KprobesTriggered))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RuntimeCompilationTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeCompilationTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeCompilationTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.KernelHeaderFetchResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KernelHeaderFetchResult))
		i--
		dAtA[i] = 0x20
	}
	if m.RuntimeCompilationDuration != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RuntimeCompilationDuration))
		i--
		dAtA[i] = 0x18
	}
	if m.RuntimeCompilationResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RuntimeCompilationResult))
		i--
		dAtA[i] = 0x10
	}
	if m.RuntimeCompilationEnabled {
		i--
		if m.RuntimeCompilationEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AgentConfiguration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentConfiguration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AgentConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CsmEnabled {
		i--
		if m.CsmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.CcmEnabled {
		i--
		if m.CcmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.DsmEnabled {
		i--
		if m.DsmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.UsmEnabled {
		i--
		if m.UsmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.NpmEnabled {
		i--
		if m.NpmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Route) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Route) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Route) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Subnet != nil {
		{
			size, err := m.Subnet.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Subnet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subnet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Subnet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Alias) > 0 {
		i -= len(m.Alias)
		copy(dAtA[i:], m.Alias)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Alias)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RouteMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RouteMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.TagsModified != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsModified))
		i--
		dAtA[i] = 0x18
	}
	if m.TagIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagIndex))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Alias) > 0 {
		i -= len(m.Alias)
		copy(dAtA[i:], m.Alias)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Alias)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IPTranslation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPTranslation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPTranslation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ReplDstPort != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ReplDstPort))
		i--
		dAtA[i] = 0x20
	}
	if m.ReplSrcPort != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ReplSrcPort))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ReplDstIP) > 0 {
		i -= len(m.ReplDstIP)
		copy(dAtA[i:], m.ReplDstIP)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ReplDstIP)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ReplSrcIP) > 0 {
		i -= len(m.ReplSrcIP)
		copy(dAtA[i:], m.ReplSrcIP)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ReplSrcIP)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Addr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Addr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Addr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Port != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Ip) > 0 {
		i -= len(m.Ip)
		copy(dAtA[i:], m.Ip)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Ip)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *ProtocolStack) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProtocolStack) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProtocolStack) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Stack) > 0 {
		for iNdEx := len(m.Stack) - 1; iNdEx >= 0; iNdEx-- {
			i = encodeVarintConnections(dAtA, i, uint64(m.Stack[iNdEx]))
			i--
			dAtA[i] = 0x8
		}
	}
	return len(dAtA) - i, nil
}

func (m *DNSEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DNSStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DnsCountByRcode) > 0 {
		for k := range m.DnsCountByRcode {
			v := m.DnsCountByRcode[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.DnsFailureLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsFailureLatencySum))
		i--
		dAtA[i] = 0x18
	}
	if m.DnsSuccessLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsSuccessLatencySum))
		i--
		dAtA[i] = 0x10
	}
	if m.DnsTimeouts != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsTimeouts))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DNSStatsByQueryType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSStatsByQueryType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSStatsByQueryType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DnsStatsByQueryType) > 0 {
		for k := range m.DnsStatsByQueryType {
			v := m.DnsStatsByQueryType[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintConnections(dAtA []byte, offset int, v uint64) int {
	offset -= sovConnections(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CollectorConnections) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Connections) > 0 {
		for _, e := range m.Connections {
			l = e.Size()
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if m.GroupId != 0 {
		n += 1 + sovConnections(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovConnections(uint64(m.GroupSize))
	}
	if len(m.ResolvedResources) > 0 {
		for k, v := range m.ResolvedResources {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.ContainerForPid) > 0 {
		for k, v := range m.ContainerForPid {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + len(v) + sovConnections(uint64(len(v)))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	l = len(m.EncodedTags)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.NetworkId)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedDNS)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.ContainerHostType != 0 {
		n += 1 + sovConnections(uint64(m.ContainerHostType))
	}
	if m.ConnTelemetry != nil {
		l = m.ConnTelemetry.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.Architecture)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.KernelVersion)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.Platform)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.PlatformVersion)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k, v := range m.CompilationTelemetryByAsset {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			l = len(s)
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	if len(m.RouteMetadata) > 0 {
		for _, e := range m.RouteMetadata {
			l = e.Size()
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	if m.AgentConfiguration != nil {
		l = m.AgentConfiguration.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedDomainDatabase)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedDnsLookups)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedConnectionsTags)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k, v := range m.ConnTelemetryMap {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.ResolvedHostsByName) > 0 {
		for k, v := range m.ResolvedHostsByName {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		n += 2 + sovConnections(uint64(m.KernelHeaderFetchResult))
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k, v := range m.CORETelemetryByAsset {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.PrebuiltEBPFAssets) > 0 {
		for _, s := range m.PrebuiltEBPFAssets {
			l = len(s)
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	l = len(m.EcsTask)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *Connections) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Conns) > 0 {
		for _, e := range m.Conns {
			l = e.Size()
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.Dns) > 0 {
		for k, v := range m.Dns {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.ConnTelemetry != nil {
		l = m.ConnTelemetry.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k, v := range m.CompilationTelemetryByAsset {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.AgentConfiguration != nil {
		l = m.AgentConfiguration.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k, v := range m.ConnTelemetryMap {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		n += 1 + sovConnections(uint64(m.KernelHeaderFetchResult))
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k, v := range m.CORETelemetryByAsset {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.PrebuiltEBPFAssets) > 0 {
		for _, s := range m.PrebuiltEBPFAssets {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	return n
}

func (m *Connection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Pid != 0 {
		n += 1 + sovConnections(uint64(m.Pid))
	}
	if m.Laddr != nil {
		l = m.Laddr.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.Raddr != nil {
		l = m.Raddr.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.Family != 0 {
		n += 1 + sovConnections(uint64(m.Family))
	}
	if m.Type != 0 {
		n += 1 + sovConnections(uint64(m.Type))
	}
	if m.LastBytesSent != 0 {
		n += 2 + sovConnections(uint64(m.LastBytesSent))
	}
	if m.LastBytesReceived != 0 {
		n += 2 + sovConnections(uint64(m.LastBytesReceived))
	}
	if m.LastRetransmits != 0 {
		n += 2 + sovConnections(uint64(m.LastRetransmits))
	}
	if m.Direction != 0 {
		n += 2 + sovConnections(uint64(m.Direction))
	}
	if m.NetNS != 0 {
		n += 2 + sovConnections(uint64(m.NetNS))
	}
	if m.IpTranslation != nil {
		l = m.IpTranslation.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	if m.Rtt != 0 {
		n += 2 + sovConnections(uint64(m.Rtt))
	}
	if m.RttVar != 0 {
		n += 2 + sovConnections(uint64(m.RttVar))
	}
	if m.IntraHost {
		n += 3
	}
	if m.DnsSuccessfulResponses != 0 {
		n += 2 + sovConnections(uint64(m.DnsSuccessfulResponses))
	}
	if m.DnsFailedResponses != 0 {
		n += 2 + sovConnections(uint64(m.DnsFailedResponses))
	}
	if m.DnsTimeouts != 0 {
		n += 2 + sovConnections(uint64(m.DnsTimeouts))
	}
	if m.DnsSuccessLatencySum != 0 {
		n += 2 + sovConnections(uint64(m.DnsSuccessLatencySum))
	}
	if m.DnsFailureLatencySum != 0 {
		n += 2 + sovConnections(uint64(m.DnsFailureLatencySum))
	}
	if m.LastTcpEstablished != 0 {
		n += 2 + sovConnections(uint64(m.LastTcpEstablished))
	}
	if m.LastTcpClosed != 0 {
		n += 2 + sovConnections(uint64(m.LastTcpClosed))
	}
	l = len(m.RemoteNetworkId)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.DnsCountByRcode) > 0 {
		for k, v := range m.DnsCountByRcode {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.DnsStatsByDomain) > 0 {
		for k, v := range m.DnsStatsByDomain {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.RouteIdx != 0 {
		n += 2 + sovConnections(uint64(m.RouteIdx))
	}
	l = len(m.HttpAggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if m.LastPacketsSent != 0 {
		n += 2 + sovConnections(uint64(m.LastPacketsSent))
	}
	if m.LastPacketsReceived != 0 {
		n += 2 + sovConnections(uint64(m.LastPacketsReceived))
	}
	if m.RouteTargetIdx != 0 {
		n += 2 + sovConnections(uint64(m.RouteTargetIdx))
	}
	if m.IsLocalPortEphemeral != 0 {
		n += 2 + sovConnections(uint64(m.IsLocalPortEphemeral))
	}
	if len(m.DnsStatsByDomainByQueryType) > 0 {
		for k, v := range m.DnsStatsByDomainByQueryType {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.DnsStatsByDomainOffsetByQueryType) > 0 {
		for k, v := range m.DnsStatsByDomainOffsetByQueryType {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.Tags) > 0 {
		for _, e := range m.Tags {
			n += 2 + sovConnections(uint64(e))
		}
	}
	if m.TagsIdx != 0 {
		n += 2 + sovConnections(uint64(m.TagsIdx))
	}
	if m.StateIndex != 0 {
		n += 2 + sovConnections(uint64(m.StateIndex))
	}
	if m.TagsChecksum != 0 {
		n += 2 + sovConnections(uint64(m.TagsChecksum))
	}
	if m.Protocol != nil {
		l = m.Protocol.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.DataStreamsAggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.Http2Aggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.DatabaseAggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.TcpFailuresByErrCode) > 0 {
		for k, v := range m.TcpFailuresByErrCode {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	l = len(m.RemoteEcsTask)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *ResourceMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.ByteKey)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if m.TagIndex != 0 {
		n += 1 + sovConnections(uint64(m.TagIndex))
	}
	if m.TagsModified != 0 {
		n += 1 + sovConnections(uint64(m.TagsModified))
	}
	return n
}

func (m *ConnectionsTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MonotonicKprobesTriggered != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicKprobesTriggered))
	}
	if m.MonotonicKprobesMissed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicKprobesMissed))
	}
	if m.MonotonicConntrackRegisters != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicConntrackRegisters))
	}
	if m.MonotonicConntrackRegistersDropped != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicConntrackRegistersDropped))
	}
	if m.MonotonicDnsPacketsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicDnsPacketsProcessed))
	}
	if m.MonotonicConnsClosed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicConnsClosed))
	}
	if m.ConnsBpfMapSize != 0 {
		n += 1 + sovConnections(uint64(m.ConnsBpfMapSize))
	}
	if m.MonotonicUdpSendsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicUdpSendsProcessed))
	}
	if m.MonotonicUdpSendsMissed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicUdpSendsMissed))
	}
	if m.ConntrackSamplingPercent != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackSamplingPercent))
	}
	if m.DnsStatsDropped != 0 {
		n += 1 + sovConnections(uint64(m.DnsStatsDropped))
	}
	return n
}

func (m *CollectorConnectionsTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KprobesTriggered != 0 {
		n += 1 + sovConnections(uint64(m.KprobesTriggered))
	}
	if m.KprobesMissed != 0 {
		n += 1 + sovConnections(uint64(m.KprobesMissed))
	}
	if m.ConntrackRegisters != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackRegisters))
	}
	if m.ConntrackRegistersDropped != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackRegistersDropped))
	}
	if m.DnsPacketsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.DnsPacketsProcessed))
	}
	if m.ConnsClosed != 0 {
		n += 1 + sovConnections(uint64(m.ConnsClosed))
	}
	if m.ConnsBpfMapSize != 0 {
		n += 1 + sovConnections(uint64(m.ConnsBpfMapSize))
	}
	if m.UdpSendsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.UdpSendsProcessed))
	}
	if m.UdpSendsMissed != 0 {
		n += 1 + sovConnections(uint64(m.UdpSendsMissed))
	}
	if m.ConntrackSamplingPercent != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackSamplingPercent))
	}
	if m.DnsStatsDropped != 0 {
		n += 1 + sovConnections(uint64(m.DnsStatsDropped))
	}
	return n
}

func (m *RuntimeCompilationTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RuntimeCompilationEnabled {
		n += 2
	}
	if m.RuntimeCompilationResult != 0 {
		n += 1 + sovConnections(uint64(m.RuntimeCompilationResult))
	}
	if m.RuntimeCompilationDuration != 0 {
		n += 1 + sovConnections(uint64(m.RuntimeCompilationDuration))
	}
	if m.KernelHeaderFetchResult != 0 {
		n += 1 + sovConnections(uint64(m.KernelHeaderFetchResult))
	}
	return n
}

func (m *AgentConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NpmEnabled {
		n += 2
	}
	if m.UsmEnabled {
		n += 2
	}
	if m.DsmEnabled {
		n += 2
	}
	if m.CcmEnabled {
		n += 2
	}
	if m.CsmEnabled {
		n += 2
	}
	return n
}

func (m *Route) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subnet != nil {
		l = m.Subnet.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *Subnet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Alias)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *RouteMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Alias)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.TagIndex != 0 {
		n += 1 + sovConnections(uint64(m.TagIndex))
	}
	if m.TagsModified != 0 {
		n += 1 + sovConnections(uint64(m.TagsModified))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	return n
}

func (m *IPTranslation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ReplSrcIP)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.ReplDstIP)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.ReplSrcPort != 0 {
		n += 1 + sovConnections(uint64(m.ReplSrcPort))
	}
	if m.ReplDstPort != 0 {
		n += 1 + sovConnections(uint64(m.ReplDstPort))
	}
	return n
}

func (m *Addr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ip)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConnections(uint64(m.Port))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *ProtocolStack) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Stack) > 0 {
		for _, e := range m.Stack {
			n += 1 + sovConnections(uint64(e))
		}
	}
	return n
}

func (m *DNSEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	return n
}

func (m *DNSStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DnsTimeouts != 0 {
		n += 1 + sovConnections(uint64(m.DnsTimeouts))
	}
	if m.DnsSuccessLatencySum != 0 {
		n += 1 + sovConnections(uint64(m.DnsSuccessLatencySum))
	}
	if m.DnsFailureLatencySum != 0 {
		n += 1 + sovConnections(uint64(m.DnsFailureLatencySum))
	}
	if len(m.DnsCountByRcode) > 0 {
		for k, v := range m.DnsCountByRcode {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *DNSStatsByQueryType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DnsStatsByQueryType) > 0 {
		for k, v := range m.DnsStatsByQueryType {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	return n
}

func sovConnections(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConnections(x uint64) (n int) {
	return sovConnections(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CollectorConnections) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectorConnections: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectorConnections: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connections", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Connections = append(m.Connections, &Connection{})
			if err := m.Connections[len(m.Connections)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			m.GroupId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupSize", wireType)
			}
			m.GroupSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolvedResources == nil {
				m.ResolvedResources = make(map[string]*ResourceMetadata)
			}
			var mapkey string
			var mapvalue *ResourceMetadata
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ResourceMetadata{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResolvedResources[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerForPid", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerForPid == nil {
				m.ContainerForPid = make(map[int32]string)
			}
			var mapkey int32
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ContainerForPid[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedTags", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedTags = append(m.EncodedTags[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedTags == nil {
				m.EncodedTags = []byte{}
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedDNS", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedDNS = append(m.EncodedDNS[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedDNS == nil {
				m.EncodedDNS = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerHostType", wireType)
			}
			m.ContainerHostType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContainerHostType |= ContainerHostType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetry == nil {
				m.ConnTelemetry = &CollectorConnectionsTelemetry{}
			}
			if err := m.ConnTelemetry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Architecture", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Architecture = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KernelVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platform = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlatformVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PlatformVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompilationTelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompilationTelemetryByAsset == nil {
				m.CompilationTelemetryByAsset = make(map[string]*RuntimeCompilationTelemetry)
			}
			var mapkey string
			var mapvalue *RuntimeCompilationTelemetry
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RuntimeCompilationTelemetry{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CompilationTelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Domains", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Domains = append(m.Domains, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, &Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RouteMetadata = append(m.RouteMetadata, &RouteMetadata{})
			if err := m.RouteMetadata[len(m.RouteMetadata)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentConfiguration == nil {
				m.AgentConfiguration = &AgentConfiguration{}
			}
			if err := m.AgentConfiguration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedDomainDatabase", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedDomainDatabase = append(m.EncodedDomainDatabase[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedDomainDatabase == nil {
				m.EncodedDomainDatabase = []byte{}
			}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedDnsLookups", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedDnsLookups = append(m.EncodedDnsLookups[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedDnsLookups == nil {
				m.EncodedDnsLookups = []byte{}
			}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedConnectionsTags", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedConnectionsTags = append(m.EncodedConnectionsTags[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedConnectionsTags == nil {
				m.EncodedConnectionsTags = []byte{}
			}
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetryMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetryMap == nil {
				m.ConnTelemetryMap = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ConnTelemetryMap[mapkey] = mapvalue
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedHostsByName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolvedHostsByName == nil {
				m.ResolvedHostsByName = make(map[string]*Host)
			}
			var mapkey string
			var mapvalue *Host
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Host{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResolvedHostsByName[mapkey] = mapvalue
			iNdEx = postIndex
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelHeaderFetchResult", wireType)
			}
			m.KernelHeaderFetchResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelHeaderFetchResult |= KernelHeaderFetchResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CORETelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CORETelemetryByAsset == nil {
				m.CORETelemetryByAsset = make(map[string]COREResult)
			}
			var mapkey string
			var mapvalue COREResult
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= COREResult(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CORETelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrebuiltEBPFAssets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrebuiltEBPFAssets = append(m.PrebuiltEBPFAssets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EcsTask", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EcsTask = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connections) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connections: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connections: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conns = append(m.Conns, &Connection{})
			if err := m.Conns[len(m.Conns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dns == nil {
				m.Dns = make(map[string]*DNSEntry)
			}
			var mapkey string
			var mapvalue *DNSEntry
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSEntry{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dns[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetry == nil {
				m.ConnTelemetry = &ConnectionsTelemetry{}
			}
			if err := m.ConnTelemetry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Domains", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Domains = append(m.Domains, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, &Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompilationTelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompilationTelemetryByAsset == nil {
				m.CompilationTelemetryByAsset = make(map[string]*RuntimeCompilationTelemetry)
			}
			var mapkey string
			var mapvalue *RuntimeCompilationTelemetry
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RuntimeCompilationTelemetry{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CompilationTelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentConfiguration == nil {
				m.AgentConfiguration = &AgentConfiguration{}
			}
			if err := m.AgentConfiguration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetryMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetryMap == nil {
				m.ConnTelemetryMap = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ConnTelemetryMap[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelHeaderFetchResult", wireType)
			}
			m.KernelHeaderFetchResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelHeaderFetchResult |= KernelHeaderFetchResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CORETelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CORETelemetryByAsset == nil {
				m.CORETelemetryByAsset = make(map[string]COREResult)
			}
			var mapkey string
			var mapvalue COREResult
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= COREResult(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CORETelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrebuiltEBPFAssets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrebuiltEBPFAssets = append(m.PrebuiltEBPFAssets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			m.Pid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Pid |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Laddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Laddr == nil {
				m.Laddr = &Addr{}
			}
			if err := m.Laddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Raddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Raddr == nil {
				m.Raddr = &Addr{}
			}
			if err := m.Raddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			m.Family = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Family |= ConnectionFamily(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= ConnectionType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastBytesSent", wireType)
			}
			m.LastBytesSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastBytesSent |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastBytesReceived", wireType)
			}
			m.LastBytesReceived = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastBytesReceived |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRetransmits", wireType)
			}
			m.LastRetransmits = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastRetransmits |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			m.Direction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Direction |= ConnectionDirection(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetNS", wireType)
			}
			m.NetNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NetNS |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpTranslation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IpTranslation == nil {
				m.IpTranslation = &IPTranslation{}
			}
			if err := m.IpTranslation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rtt", wireType)
			}
			m.Rtt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Rtt |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RttVar", wireType)
			}
			m.RttVar = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RttVar |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntraHost", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntraHost = bool(v != 0)
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsSuccessfulResponses", wireType)
			}
			m.DnsSuccessfulResponses = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsSuccessfulResponses |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsFailedResponses", wireType)
			}
			m.DnsFailedResponses = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsFailedResponses |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsTimeouts", wireType)
			}
			m.DnsTimeouts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsTimeouts |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 28:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsSuccessLatencySum", wireType)
			}
			m.DnsSuccessLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsSuccessLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsFailureLatencySum", wireType)
			}
			m.DnsFailureLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsFailureLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastTcpEstablished", wireType)
			}
			m.LastTcpEstablished = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastTcpEstablished |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastTcpClosed", wireType)
			}
			m.LastTcpClosed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastTcpClosed |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteNetworkId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteNetworkId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsCountByRcode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsCountByRcode == nil {
				m.DnsCountByRcode = make(map[uint32]uint32)
			}
			var mapkey uint32
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsCountByRcode[mapkey] = mapvalue
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByDomain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByDomain == nil {
				m.DnsStatsByDomain = make(map[int32]*DNSStats)
			}
			var mapkey int32
			var mapvalue *DNSStats
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStats{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByDomain[mapkey] = mapvalue
			iNdEx = postIndex
		case 36:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteIdx", wireType)
			}
			m.RouteIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RouteIdx |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpAggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpAggregations = append(m.HttpAggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.HttpAggregations == nil {
				m.HttpAggregations = []byte{}
			}
			iNdEx = postIndex
		case 38:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastPacketsSent", wireType)
			}
			m.LastPacketsSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastPacketsSent |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 39:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastPacketsReceived", wireType)
			}
			m.LastPacketsReceived = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastPacketsReceived |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 40:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteTargetIdx", wireType)
			}
			m.RouteTargetIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RouteTargetIdx |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLocalPortEphemeral", wireType)
			}
			m.IsLocalPortEphemeral = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IsLocalPortEphemeral |= EphemeralPortState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByDomainByQueryType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByDomainByQueryType == nil {
				m.DnsStatsByDomainByQueryType = make(map[int32]*DNSStatsByQueryType)
			}
			var mapkey int32
			var mapvalue *DNSStatsByQueryType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStatsByQueryType{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByDomainByQueryType[mapkey] = mapvalue
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByDomainOffsetByQueryType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByDomainOffsetByQueryType == nil {
				m.DnsStatsByDomainOffsetByQueryType = make(map[int32]*DNSStatsByQueryType)
			}
			var mapkey int32
			var mapvalue *DNSStatsByQueryType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStatsByQueryType{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByDomainOffsetByQueryType[mapkey] = mapvalue
			iNdEx = postIndex
		case 44:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Tags = append(m.Tags, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConnections
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthConnections
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Tags) == 0 {
					m.Tags = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Tags = append(m.Tags, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
		case 45:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsIdx", wireType)
			}
			m.TagsIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsIdx |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 46:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StateIndex", wireType)
			}
			m.StateIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StateIndex |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 47:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsChecksum", wireType)
			}
			m.TagsChecksum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsChecksum |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 48:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Protocol == nil {
				m.Protocol = &ProtocolStack{}
			}
			if err := m.Protocol.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 49:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataStreamsAggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataStreamsAggregations = append(m.DataStreamsAggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.DataStreamsAggregations == nil {
				m.DataStreamsAggregations = []byte{}
			}
			iNdEx = postIndex
		case 50:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2Aggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Http2Aggregations = append(m.Http2Aggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.Http2Aggregations == nil {
				m.Http2Aggregations = []byte{}
			}
			iNdEx = postIndex
		case 51:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseAggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DatabaseAggregations = append(m.DatabaseAggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.DatabaseAggregations == nil {
				m.DatabaseAggregations = []byte{}
			}
			iNdEx = postIndex
		case 52:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpFailuresByErrCode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpFailuresByErrCode == nil {
				m.TcpFailuresByErrCode = make(map[uint32]uint32)
			}
			var mapkey uint32
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TcpFailuresByErrCode[mapkey] = mapvalue
			iNdEx = postIndex
		case 53:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteEcsTask", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteEcsTask = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ByteKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ByteKey = append(m.ByteKey[:0], dAtA[iNdEx:postIndex]...)
			if m.ByteKey == nil {
				m.ByteKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagIndex", wireType)
			}
			m.TagIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsModified", wireType)
			}
			m.TagsModified = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsModified |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionsTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectionsTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectionsTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicKprobesTriggered", wireType)
			}
			m.MonotonicKprobesTriggered = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicKprobesTriggered |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicKprobesMissed", wireType)
			}
			m.MonotonicKprobesMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicKprobesMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicConntrackRegisters", wireType)
			}
			m.MonotonicConntrackRegisters = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicConntrackRegisters |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicConntrackRegistersDropped", wireType)
			}
			m.MonotonicConntrackRegistersDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicConntrackRegistersDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicDnsPacketsProcessed", wireType)
			}
			m.MonotonicDnsPacketsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicDnsPacketsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicConnsClosed", wireType)
			}
			m.MonotonicConnsClosed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicConnsClosed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnsBpfMapSize", wireType)
			}
			m.ConnsBpfMapSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnsBpfMapSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicUdpSendsProcessed", wireType)
			}
			m.MonotonicUdpSendsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicUdpSendsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicUdpSendsMissed", wireType)
			}
			m.MonotonicUdpSendsMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicUdpSendsMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackSamplingPercent", wireType)
			}
			m.ConntrackSamplingPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackSamplingPercent |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsDropped", wireType)
			}
			m.DnsStatsDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsStatsDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CollectorConnectionsTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectorConnectionsTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectorConnectionsTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KprobesTriggered", wireType)
			}
			m.KprobesTriggered = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KprobesTriggered |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KprobesMissed", wireType)
			}
			m.KprobesMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KprobesMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackRegisters", wireType)
			}
			m.ConntrackRegisters = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackRegisters |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackRegistersDropped", wireType)
			}
			m.ConntrackRegistersDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackRegistersDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsPacketsProcessed", wireType)
			}
			m.DnsPacketsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsPacketsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnsClosed", wireType)
			}
			m.ConnsClosed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnsClosed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnsBpfMapSize", wireType)
			}
			m.ConnsBpfMapSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnsBpfMapSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UdpSendsProcessed", wireType)
			}
			m.UdpSendsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UdpSendsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UdpSendsMissed", wireType)
			}
			m.UdpSendsMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UdpSendsMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackSamplingPercent", wireType)
			}
			m.ConntrackSamplingPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackSamplingPercent |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsDropped", wireType)
			}
			m.DnsStatsDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsStatsDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeCompilationTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuntimeCompilationTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuntimeCompilationTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeCompilationEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RuntimeCompilationEnabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeCompilationResult", wireType)
			}
			m.RuntimeCompilationResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RuntimeCompilationResult |= RuntimeCompilationResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeCompilationDuration", wireType)
			}
			m.RuntimeCompilationDuration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RuntimeCompilationDuration |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelHeaderFetchResult", wireType)
			}
			m.KernelHeaderFetchResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelHeaderFetchResult |= KernelHeaderFetchResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AgentConfiguration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AgentConfiguration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AgentConfiguration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NpmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NpmEnabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UsmEnabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DsmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DsmEnabled = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CcmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CcmEnabled = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CsmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CsmEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Route) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Route: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Route: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subnet", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subnet == nil {
				m.Subnet = &Subnet{}
			}
			if err := m.Subnet.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subnet) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subnet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subnet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alias", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alias = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alias", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alias = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagIndex", wireType)
			}
			m.TagIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsModified", wireType)
			}
			m.TagsModified = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsModified |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPTranslation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPTranslation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPTranslation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplSrcIP", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplSrcIP = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplDstIP", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplDstIP = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplSrcPort", wireType)
			}
			m.ReplSrcPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplSrcPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplDstPort", wireType)
			}
			m.ReplDstPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplDstPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Addr) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Addr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Addr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ip = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProtocolStack) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProtocolStack: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProtocolStack: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v ProtocolType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= ProtocolType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Stack = append(m.Stack, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConnections
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthConnections
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Stack) == 0 {
					m.Stack = make([]ProtocolType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v ProtocolType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= ProtocolType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Stack = append(m.Stack, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Stack", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsTimeouts", wireType)
			}
			m.DnsTimeouts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsTimeouts |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsSuccessLatencySum", wireType)
			}
			m.DnsSuccessLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsSuccessLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsFailureLatencySum", wireType)
			}
			m.DnsFailureLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsFailureLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsCountByRcode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsCountByRcode == nil {
				m.DnsCountByRcode = make(map[uint32]uint32)
			}
			var mapkey uint32
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsCountByRcode[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSStatsByQueryType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSStatsByQueryType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSStatsByQueryType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByQueryType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByQueryType == nil {
				m.DnsStatsByQueryType = make(map[int32]*DNSStats)
			}
			var mapkey int32
			var mapvalue *DNSStats
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStats{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByQueryType[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConnections(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConnections
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupConnections
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthConnections
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthConnections        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConnections          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupConnections = fmt.Errorf("proto: unexpected end of group")
)
