import { getParentCounts } from "../../dag/utils";
import { map } from "../../iters";
/** @internal */
function buildOperator(options) {
    function longestPathCall(dag) {
        var _a;
        if (options.topDown) {
            const parents = getParentCounts(dag);
            for (const node of dag.idescendants("before")) {
                node.value = Math.max(0, ...map((_a = parents.get(node)) !== null && _a !== void 0 ? _a : [], ([par, count]) => par.value + (count > 1 ? 2 : 1)));
            }
        }
        else {
            let maxHeight = 0;
            for (const node of dag.idescendants("after")) {
                node.value = Math.max(0, ...map(node.ichildrenCounts(), ([child, count]) => child.value + (count > 1 ? 2 : 1)));
                maxHeight = Math.max(maxHeight, node.value);
            }
            for (const node of dag) {
                node.value = maxHeight - node.value;
            }
        }
    }
    function topDown(val) {
        if (val === undefined) {
            return options.topDown;
        }
        else {
            return buildOperator(Object.assign(Object.assign({}, options), { topDown: val }));
        }
    }
    longestPathCall.topDown = topDown;
    return longestPathCall;
}
/**
 * Create a default {@link LongestPathOperator}, bundled as
 * {@link layeringLongestPath}.
 */
export function longestPath(...args) {
    if (args.length) {
        throw new Error(`got arguments to longestPath(${args}), but constructor takes no arguments.`);
    }
    return buildOperator({ topDown: true });
}
